% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_mixed_cc.R
\name{sim_mixed_cc}
\alias{sim_mixed_cc}
\title{Generate a cross-classified sample}
\usage{
sim_mixed_cc(
  sub_n = 100,
  item_n = 20,
  grand_i = 0,
  sub_sd = 1,
  item_sd = 1,
  error_sd = 1,
  empirical = FALSE
)
}
\arguments{
\item{sub_n}{the number of subjects}

\item{item_n}{the number of items}

\item{grand_i}{the grand intercept (overall mean)}

\item{sub_sd}{the SD of subject random intercepts (or a sub_n-length named vector of random intercepts for each subject)}

\item{item_sd}{the SD of item random intercepts (or an item_n-length named vector of random intercepts for each item)}

\item{error_sd}{the SD of the error term}

\item{empirical}{Should the returned data have these exact parameters? (versus be sampled from a population with these parameters)}
}
\value{
a tbl
}
\description{
Makes a basic cross-classified design with random intercepts for subjects and items. See \href{../doc/sim_mixed.html}{\code{vignette("sim_mixed", package = "faux")}} for examples and details.
}
\examples{

sim_mixed_cc(10, 10)
}
