% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qq.R
\name{qqnorm}
\alias{qqnorm}
\title{Creates a Q-Q plot for comparing with normal quantiles}
\usage{
qqnorm(
  y,
  ylim,
  main = "Normal Q-Q Plot",
  xlab = "Theoretical Quantiles",
  ylab = "Sample Quantiles",
  plot.it = TRUE,
  datax = FALSE,
  ...
)
}
\arguments{
\item{y}{sample, to compare to normal quantiles.}

\item{ylim}{graphical limits.}

\item{main}{Plot title.}

\item{xlab}{X label.}

\item{ylab}{Y label.}

\item{plot.it}{Should the plot be created.}

\item{datax}{logical. Should data values be on x-axis?}

\item{...}{Other arguments passed to \code{plot()}}
}
\value{
\code{data.frame} with sorted sample and normal quantiles, \code{NA}
values are excluded.
}
\description{
Faster alternative to \code{stats::qqnorm()}. For more than 1e5 points
we remove excess points, that would not be visible in the plot, since the
points are so close. Otherwise this should work exactly the same, and the
code is mostly adapted from \code{stats::qqnorm()}. This code produces
more lightweight plots for excessive amounts of data.
}
\examples{
qqnorm(stats::rnorm(1e6))
}
\keyword{qq}
\keyword{qqplot}
\keyword{visualization}
