% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastpos.R
\docType{package}
\name{fastpos-package}
\alias{fastpos}
\alias{fastpos-package}
\title{fastpos: Finds the Critical Sequential Point of Stability for a Pearson Correlation}
\description{
Finds the critical sample size ("point of stability") for a 
    correlation to stabilize in Schoenbrodt and Perugini's definition of 
    sequential stability (see <doi:10.1016/j.jrp.2013.05.009>).
}
\details{
In most cases you will just need the function \code{\link{find_critical_pos}}
which will you give you the critical point of stability for your specific
parameters. If you are interested in more complicated analysis you might want
to look at the function \code{\link{simulate_pos}}, which is a C++
functions to calculate correlations and return points of stability.
}
\references{
Schönbrodt, F. D. & Perugini, M. (2013). At what sample size do
correlations stabilize? \emph{Journal of Research in Personality, 47},
609-612. \url{https://doi.org/10.1016/j.jrp.2013.05.009}

Schönbrodt, F. D. & Perugini, M. (2018) Corrigendum to “At what sample size
do correlations stabilize?” [J. Res. Pers. 47 (2013) 609–612.
https://doi.org/10.1016/j.jrp.2013.05.009]. \emph{Journal of Research in
Personality, 74}, 194. \url{https://doi.org/10.1016/j.jrp.2018.02.010}
}
\seealso{
Useful links:
\itemize{
  \item Report bugs at \url{https://github.com/johannes-titz/fastpos}
}

}
\author{
\strong{Maintainer}: Johannes Titz \email{johannes.titz@gmail.com} [copyright holder]

}
\keyword{internal}
