% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_id.R
\name{add_group_id}
\alias{add_group_id}
\alias{add_group_id.data.frame}
\alias{add_row_id}
\alias{add_row_id.data.frame}
\alias{add_consecutive_id}
\alias{add_consecutive_id.data.frame}
\title{Add a column of useful IDs (group IDs, row IDs & consecutive IDs)}
\usage{
add_group_id(data, ...)

\method{add_group_id}{data.frame}(
  data,
  ...,
  .order = df_group_by_order_default(data),
  .ascending = TRUE,
  .by = NULL,
  .cols = NULL,
  .name = NULL,
  as_qg = FALSE
)

add_row_id(data, ...)

\method{add_row_id}{data.frame}(
  data,
  ...,
  .ascending = TRUE,
  .by = NULL,
  .cols = NULL,
  .name = NULL
)

add_consecutive_id(data, ...)

\method{add_consecutive_id}{data.frame}(
  data,
  ...,
  .order = df_group_by_order_default(data),
  .by = NULL,
  .cols = NULL,
  .name = NULL
)
}
\arguments{
\item{data}{A data frame.}

\item{...}{Additional groups using tidy \code{data-masking} rules. \cr
To specify groups using \code{tidyselect}, simply use the \code{.by} argument.}

\item{.order}{Should the groups be ordered? \cr
When \code{.order} is \code{TRUE} (the default) the group IDs will be
ordered but not sorted. \cr
If \code{FALSE} the order of the group IDs will be based on first appearance.}

\item{.ascending}{Should the order be ascending or descending?
The default is \code{TRUE}. \cr
For \code{add_row_id()} this determines if the
row IDs are in increasing or decreasing order. \cr
\bold{NOTE} - When \code{order = FALSE}, the \code{ascending} argument is
ignored. This is something that will be fixed in a later version.}

\item{.by}{Alternative way of supplying groups using \code{tidyselect} notation.}

\item{.cols}{(Optional) alternative to \code{...} that accepts
a named character vector or numeric vector.
If speed is an expensive resource, it is recommended to use this.}

\item{.name}{Name of the added ID column which should be a
character vector of length 1.
If \code{.name = NULL} (the default),
\code{add_group_id()} will add a column named "group_id",
and if one already exists, a unique name will be used.}

\item{as_qg}{Should the group IDs be returned as a
collapse "qG" class? The default (\code{FALSE}) always returns
an integer vector.}
}
\value{
A data frame with the requested ID column.
}
\description{
Add a column of useful IDs (group IDs, row IDs & consecutive IDs)
}
\seealso{
\link{group_id} \link{row_id} \link{f_consecutive_id}
}
