% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glm_methods.R
\name{predict.fastglm}
\alias{predict.fastglm}
\title{Obtains predictions and optionally estimates standard errors of those predictions from a fitted generalized linear model object.}
\usage{
\method{predict}{fastglm}(object, newdata = NULL, type = c("link",
  "response"), se.fit = FALSE, dispersion = NULL, ...)
}
\arguments{
\item{object}{a fitted object of class inheriting from "\code{fastglm}".}

\item{newdata}{a matrix to be used for prediction}

\item{type}{the type of prediction required. The default is on the scale of the linear predictors;
the alternative "\code{response}" is on the scale of the response variable. Thus for a default binomial
model the default predictions are of log-odds (probabilities on logit scale) and \code{type = "response"}
 gives the predicted probabilities. The "\code{terms}" option returns a matrix giving the fitted values of each
 term in the model formula on the linear predictor scale.

The value of this argument can be abbreviated.}

\item{se.fit}{logical switch indicating if standard errors are required.}

\item{dispersion}{the dispersion of the GLM fit to be assumed in computing the standard errors.
If omitted, that returned by \code{summary} applied to the object is used.}

\item{...}{further arguments passed to or from other methods.}
}
\description{
Obtains predictions and optionally estimates standard errors of those predictions from a fitted generalized linear model object.
}
