% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/longlat.r
\name{longlat,GRaster-method}
\alias{longlat,GRaster-method}
\alias{longlat}
\title{Create longitude/latitude rasters}
\usage{
\S4method{longlat}{GRaster}(x, degrees = TRUE)
}
\arguments{
\item{x}{A \code{GRaster}.}

\item{degrees}{Logical: If \code{TRUE} (default), coordinate values of cells will be in degrees. If \code{FALSE}, and \code{x} is in a projected coordinate reference system, values will represent coordinates in map units (usually meters). Values will always be in degrees when the coordinate reference system is unprojected (e.g., WGS84, NAD83, etc.).}
}
\value{
A \code{GRaster} stack.
}
\description{
\code{longlat()} creates two rasters, one with cell values equal to the longitude of the cell centers, and one with cell values equal to the latitude of the cell centers.
}
\examples{
if (grassStarted()) {

# Setup
library(terra)

# Example data
madElev <- fastData("madElev")

# Convert a SpatRaster to a GRaster
elev <- fast(madElev)

# Create longitude/latitude rasters
ll <- longlat(elev)
ll # note units of cell values!

}
}
\seealso{
\code{\link[=init]{init()}}
}
