% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/res.r
\name{res,missing-method}
\alias{res,missing-method}
\alias{res}
\alias{res,GRegion-method}
\alias{xres,missing-method}
\alias{xres}
\alias{xres,GRegion-method}
\alias{yres,missing-method}
\alias{yres}
\alias{yres,GRegion-method}
\alias{zres,missing-method}
\alias{zres}
\alias{zres,GRegion-method}
\alias{res3d,missing-method}
\alias{res3d}
\alias{res3d,GRegion-method}
\title{Spatial resolution}
\usage{
\S4method{res}{missing}(x)

\S4method{res}{GRegion}(x)

\S4method{xres}{missing}(x)

\S4method{xres}{GRegion}(x)

\S4method{yres}{missing}(x)

\S4method{yres}{GRegion}(x)

\S4method{zres}{missing}(x)

\S4method{zres}{GRegion}(x)

\S4method{res3d}{missing}(x)

\S4method{res3d}{GRegion}(x)
}
\arguments{
\item{x}{A \code{GRaster}, \code{GRegion}, or missing. If missing, the resolution of the currently active "region" is returned (see \code{vignette("regions", package = "fasterRaster")}).}
}
\value{
A numeric vector. For both \code{res()} and \code{res3d()}, the first value is the length of cells in the x-direction and the second the length of cells in the y-direction. For \code{res3d()} the third value is height of a voxel (the z-direction). \code{xres()}, \code{yres()}, and \code{zres()} each return a single value.
}
\description{
Spatial resolution of a \code{GRaster}:
\itemize{
\item \code{res()}: 2-dimensional resolution (x and y).\cr\cr
\item \code{res3d()}: 3-dimensional resolution (z, y, and z).\cr\cr
\item \code{xres()}, \code{yres()}, and \code{zres()}: East-west resolution, north-south resolution, and top-bottom resolution.
}
}
\examples{
if (grassStarted()) {

# Setup
library(terra)

# Example data
madElev <- fastData("madElev")
madForest2000 <- fastData("madForest2000")

# Convert SpatRasters to GRasters
elev <- fast(madElev)
forest <- fast(madForest2000)

### GRaster properties

# plotting
plot(elev)

# dimensions
dim(elev) # rows, columns, depths, layers
nrow(elev) # rows
ncol(elev) # columns
ndepth(elev) # depths
nlyr(elev) # layers

res(elev) # resolution (2D)
res3d(elev) # resolution (3D)
zres(elev) # vertical resolution
xres(elev) # vertical resolution
yres(elev) # vertical resolution
zres(elev) # vertical resolution (NA because this is a 2D GRaster)

# cell counts
ncell(elev) # cells
ncell3d(elev) # cells (3D rasters only)

# number of NA and non-NA cells
nacell(elev)
nonnacell(elev)

# topology
topology(elev) # number of dimensions
is.2d(elev) # is it 2-dimensional?
is.3d(elev) # is it 3-dimensional?

minmax(elev) # min/max values

# "names" of the object
names(elev)

# coordinate reference system
crs(elev)
st_crs(elev)
coordRef(elev)

# extent (bounding box)
ext(elev)

# vertical extent (not defined for this raster)
zext(elev)

# data type
datatype(elev) # fasterRaster type
datatype(elev, "GRASS") # GRASS type
datatype(elev, "terra") # terra type
datatype(elev, "GDAL") # GDAL type

is.integer(elev)
is.float(elev)
is.double(elev)
is.factor(elev)

# convert data type
as.int(elev) # integer; note that "elev" is already of type "integer"
as.float(elev) # floating-precision
as.doub(elev) # double-precision

# assigning
pie <- elev
pie[] <- pi # assign all cells to the value of pi
pie

# concatenating multiple GRasters
rasts <- c(elev, forest)
rasts

# subsetting
rasts[[1]]
rasts[["madForest2000"]]

# replacing
rasts[[2]] <- 2 * forest
rasts

# adding layers
rasts[[3]] <- elev > 500 # add a layer
rasts <- c(rasts, sqrt(elev)) # add another
add(rasts) <- ln(elev)
rasts

# names
names(rasts)
names(rasts) <- c("elev_meters", "2_x_forest", "high_elevation", "sqrt_elev", "ln_elev")
rasts

# remove a layer
rasts[["2_x_forest"]] <- NULL
rasts

# number of layers
nlyr(rasts)

# correlation and covariance matrices
madLANDSAT <- fastData("madLANDSAT")
landsat <- fast(madLANDSAT) # projects matrix
layerCor(landsat) # correlation
layerCor(landsat, fun = 'cov') # covariance

}
}
\seealso{
\code{\link[terra:dimensions]{terra::res()}}
}
\keyword{res}
