% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{Fumbles}
\alias{Fumbles}
\title{NCAA football fumbles}
\format{
A data frame with 120 observations on the following 7 variables.
\itemize{ \item{team}{ NCAA football team} \item{rank}{ rank
based on fumbles per game through games on November 26, 2010}
\item{W}{ number of wins through games on November 26, 2010}
\item{L}{ number of losses through games on November 26, 2010}
\item{week1}{ number of fumbles on November 6, 2010}
\item{week2}{ number of fumbles on November 13, 2010}
\item{week3}{ number of fumbles on November 20, 2010} }
}
\source{
\url{https://www.teamrankings.com/college-football/stat/fumbles-per-game}
}
\description{
This data frame gives the number of fumbles by each NCAA FBS team for the
first three weeks in November, 2010.
}
\details{
The fumble counts listed here are total fumbles, not fumbles lost.  Some of
these fumbles were recovered by the team that fumbled.
}
\examples{

data(Fumbles)
m <- max(Fumbles$week1)
table(factor(Fumbles$week1,levels = 0:m))
favstats( ~ week1, data = Fumbles)
# compare with Poisson distribution
cbind(
		  fumbles = 0:m,
		  observedCount = table(factor(Fumbles$week1,levels = 0:m)),
		  modelCount= 120* dpois(0:m,mean(Fumbles$week1)),
		  observedPct = table(factor(Fumbles$week1,levels = 0:m))/120,
		  modelPct= dpois(0:m,mean(Fumbles$week1))
	) \%>\% signif(3)
showFumbles <- function(x, lambda = mean(x),...) {
  result <-
    gf_dhistogram( ~ week1, data = Fumbles, binwidth = 1, alpha = 0.3) \%>\%
    gf_dist("pois", lambda = mean( ~ week1, data = Fumbles) )
  print(result)
  return(result)
}
showFumbles(Fumbles$week1)
showFumbles(Fumbles$week2)
showFumbles(Fumbles$week3)

}
\keyword{datasets}
