% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{Noise}
\alias{Noise}
\title{Noise}
\format{A data frame with 50 observations on the following 5 variables.
\itemize{ \item{id}{ subject identifier} \item{score}{ score
on the test} \item{condition}{ numeric code for condition}
\item{volume}{ a factor with levels \code{high} \code{low}
\code{none}} \item{frequency}{ a factor with levels \code{continuous}
\code{intermittent} \code{none}} }}
\description{
In order to test the effect of room noise, subjects were given a test under
5 different sets of conditions: 1) no noise, 2) intermittent low volume, 3)
intermittent high volume, 4) continuous low volume, and 5) continuous high
volume.
}
\examples{

data(Noise)
Noise2 <- Noise \%>\% filter(volume != 'none')
model <- lm(score ~ volume * frequency, data = Noise2) 
anova(model)
gf_jitter(score ~ volume, data = Noise2, color = ~ frequency, 
          alpha = 0.4, width = 0.1, height = 0) \%>\%
  gf_line(score ~ volume, data = Noise2, group = ~frequency, color = ~ frequency,
          stat = "summary")
        
gf_jitter(score ~ frequency, data = Noise2, color = ~ volume, 
          alpha = 0.4, width = 0.1, height = 0) \%>\%
  gf_line(score ~ frequency, data = Noise2, group = ~ volume, color = ~ volume,
          stat = "summary")

}
\keyword{datasets}
