% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{data}
\name{endurance}
\alias{endurance}
\title{Endurance and vitamin C}
\format{A data frame with 15 observations on the following 5 variables.
\itemize{ \item{Vitamin}{ number of repetitions until reaching 50%
maximal grip after taking viatimin} \item{First}{ which treatment was
done first, a factor with levels \code{Placebo} \code{Vitamin}}
\item{Placebo}{ number of repetitions until reaching 50% maximal grip
strength after taking placebo} }}
\source{
These data are available from OzDASL, the Australasian data and
story library (\url{http://www.statsci.org/data/}).
}
\description{
The effect of a single 600 mg dose of ascorbic acid versus a sugar placebo
on the muscular endurance (as measured by repetitive grip strength trials)
of fifteen male volunteers (19-23 years old).
}
\details{
Three initial maximal contractions were performed for each subject, with the
greatest value indicating maximal grip strength. Muscular endurance was
measured by having the subjects squeeze the dynamometer, hold the
contraction for three seconds, and repeat continuously until a value of 50%
maximum grip strength was achieved for three consecutive contractions.
Endurance was defined as the number of repetitions required to go from
maximum grip strength to the initial 50% value. Subjects were given frequent
positive verbal encouragement in an effort to have them complete as many
repetitions as possible.

The study was conducted in a double-blind manner with crossover.
}
\examples{
data(endurance)
t.test(endurance$Vitamin, endurance$Placebo, paired=TRUE)
t.test(log(endurance$Vitamin), log(endurance$Placebo), paired=TRUE)
t.test(1/endurance$Vitamin, 1/endurance$Placebo, paired=TRUE)
xqqmath( ~ Vitamin - Placebo, endurance)
xqqmath( ~ log(Vitamin) - log(Placebo), endurance)
xqqmath( ~ 1/Vitamin - 1/Placebo, endurance)
}
\references{
Keith, R. E., and Merrill, E. (1983).  The effects of vitamin C
on maximum grip strength and muscular endurance.  \emph{Journal of Sports
Medicine and Physical Fitness}, 23, 253-256.
}
\keyword{datasets}

