% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/code.R
\name{fast_logistic_regression}
\alias{fast_logistic_regression}
\title{FastLR Wrapper}
\usage{
fast_logistic_regression(
  Xmm,
  ybin,
  drop_collinear_variables = FALSE,
  lm_fit_tol = 1e-07,
  do_inference_on_var = FALSE,
  num_cores = 1,
  ...
)
}
\arguments{
\item{Xmm}{The model.matrix for X (you need to create this yourself before)}

\item{ybin}{The binary response vector}

\item{drop_collinear_variables}{Should we drop perfectly collinear variables? Default is \code{FALSE} to inform the user of the problem.}

\item{lm_fit_tol}{When \code{drop_collinear_variables = TRUE}, this is the tolerance to detect collinearity among predictors.
We use the default value from \code{base::lm.fit}'s which is 1e-7. If you fit the logistic regression and
still get p-values near 1 indicating high collinearity, we recommend making this value smaller.}

\item{do_inference_on_var}{Which variables should we compute approximate standard errors of the coefficients and approximate p-values for the test of
no linear log-odds probability effect? Default is \code{FALSE} for inference on none (for speed). If not default, then \code{TRUE}
to indicate inference should be computed for all variables. If a logical vector of size \code{ncol(Xmm)} is passed in then
the indicies of the \code{TRUE} denotes which variables to compute inference for. If variables are dropped when
\code{drop_collinear_variables = TRUE}, then indicies will likewise be dropped from this vector. We do not recommend using this type
of piecewise specification until we understand how it behaves in simulation. Note: if you are just comparing
nested models using anova, there is no need to compute inference for coefficients (keep the default of \code{FALSE} for speed).}

\item{num_cores}{Number of cores to use to speed up matrix multiplication and matrix inversion (used only during inference computation). Default is 1.
Unless the number of variables, i.e. \code{ncol(Xmm)}, is large, there does not seem to be a performance gain in using multiple cores.}

\item{...}{Other arguments to be passed to \code{fastLR}. See documentation there.}
}
\value{
A list of raw results
}
\description{
Returns most of what you get from glm
}
\examples{
library(MASS); data(Pima.te)
flr = fast_logistic_regression(
	 Xmm = model.matrix(~ . - type, Pima.te), 
  ybin = as.numeric(Pima.te$type == "Yes")
)
}
