% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_event_cum_rets.R
\name{get_event_cum_rets}
\alias{get_event_cum_rets}
\title{Produce a table of cumulative event returns}
\usage{
get_event_cum_rets(
  data,
  conn,
  permno = "permno",
  event_date = "event_date",
  win_start = 0,
  win_end = 0,
  end_event_date = NULL,
  suffix = ""
)
}
\arguments{
\item{data}{data frame containing data on events}

\item{conn}{connection to a PostgreSQL database}

\item{permno}{string representing column containing PERMNOs for events}

\item{event_date}{string representing column containing dates for events}

\item{win_start}{integer representing start of trading window (e.g., -1)}

\item{win_end}{integer representing start of trading window (e.g., 1)}

\item{end_event_date}{string representing column containing ending dates for
events}

\item{suffix}{Text to be appended after "ret" in variable names.}
}
\value{
tbl_df
}
\description{
Produce a table of event returns from CRSP.
See \code{vignette("wrds-conn", package = "farr")} for more on using this function.
}
\examples{
## Not run:
\dontrun{
library(DBI)
library(dplyr, warn.conflicts = FALSE)
library(RPostgres)
pg <- dbConnect(Postgres())
events <- tibble(permno = c(14593L, 10107L),
                 event_date = as.Date(c("2019-01-31", "2019-01-31")))
get_event_cum_rets(events, pg)
}
## End(Not run)
}
