/*
 * Decompiled with CFR 0.152.
 */
package jfm.model;

import java.util.HashMap;
import jfm.lp.ModelComponent;
import jfm.xml.XMLSyntaxException;

public final class Types {
    private static HashMap<String, ELSCode> xmlToELSCode = new HashMap();
    private static HashMap<String, LimitType> xmlToLimitType = new HashMap();
    private static HashMap<String, WorkabilityType> xmlToWorkabilityType = new HashMap();
    private static HashMap<String, ObjectiveType> xmlToObjectiveType = new HashMap();
    private static HashMap<String, DiseaseType> xmlToDiseaseType = new HashMap();
    private static HashMap<String, WorkerType> xmlToWorkerType = new HashMap();
    private static HashMap<String, WorkerSubType> xmlToWorkerSubType = new HashMap();
    private static HashMap<String, CropType> xmlToCropType = new HashMap();
    private static HashMap<String, OperationType> xmlToOperationType = new HashMap();
    private static HashMap<String, TextDataType> xmlToTextDataType = new HashMap();
    private static HashMap<String, VariableType> xmlToVariableType = new HashMap();

    public static ELSCode xmlToELSCode(String str) throws XMLSyntaxException {
        if (xmlToELSCode.containsKey(str)) {
            return xmlToELSCode.get(str);
        }
        throw new XMLSyntaxException("The string " + str + " does not correspond to a variable type");
    }

    public static VariableType xmlToVariableType(String str) throws XMLSyntaxException {
        if (xmlToVariableType.containsKey(str)) {
            return xmlToVariableType.get(str);
        }
        throw new XMLSyntaxException("The string " + str + " does not correspond to a variable type");
    }

    public static LimitType xmlToLimitType(String str) throws XMLSyntaxException {
        if (xmlToLimitType.containsKey(str)) {
            return xmlToLimitType.get(str);
        }
        throw new XMLSyntaxException("The string " + str + " does not correspond to a limit type");
    }

    public static WorkabilityType xmlToWorkabilityType(String str) throws XMLSyntaxException {
        if (xmlToWorkabilityType.containsKey(str)) {
            return xmlToWorkabilityType.get(str);
        }
        throw new XMLSyntaxException("The string " + str + " does not correspond to a workability type");
    }

    public static ObjectiveType xmlToObjectiveType(String str) throws XMLSyntaxException {
        if (xmlToObjectiveType.containsKey(str)) {
            return xmlToObjectiveType.get(str);
        }
        throw new XMLSyntaxException("The string " + str + " does not correspond to an baseObjective type");
    }

    public static DiseaseType xmlToDiseaseType(String str) {
        if (xmlToDiseaseType.containsKey(str)) {
            return xmlToDiseaseType.get(str);
        }
        throw new Error("The string " + str + " does not correspond to a disease type");
    }

    public static WorkerType xmlToWorkerType(String str) throws XMLSyntaxException {
        if (xmlToWorkerType.containsKey(str)) {
            return xmlToWorkerType.get(str);
        }
        throw new XMLSyntaxException("The string " + str + " does not correspond to a worker type");
    }

    public static WorkerSubType xmlToWorkerSubType(String str) throws XMLSyntaxException {
        if (xmlToWorkerSubType.containsKey(str)) {
            return xmlToWorkerSubType.get(str);
        }
        throw new XMLSyntaxException("The string " + str + " does not correspond to a worker sub type");
    }

    public static OperationType xmlToOperationType(String str) {
        if (xmlToOperationType.containsKey(str)) {
            return xmlToOperationType.get(str);
        }
        throw new Error("The string " + str + " does not correspond to a operation type");
    }

    public static TextDataType xmlToTextDataType(String str) {
        if (xmlToTextDataType.containsKey(str)) {
            return xmlToTextDataType.get(str);
        }
        throw new Error("The string " + str + " does not correspond to a csv type");
    }

    public static CropType xmlToCropType(String str) throws XMLSyntaxException {
        if (xmlToCropType.containsKey(str)) {
            return xmlToCropType.get(str);
        }
        throw new XMLSyntaxException("The string " + str + " does not correspond to a crop type");
    }

    public static boolean variableTypeExists(String xmln) {
        return xmlToVariableType.containsKey(xmln);
    }

    static {
        for (ELSCode eLSCode : ELSCode.values()) {
            xmlToELSCode.put(eLSCode.xmlname, eLSCode);
        }
        for (Enum enum_ : VariableType.values()) {
            xmlToVariableType.put(((VariableType)enum_).xmlname, (VariableType)enum_);
        }
        for (Enum enum_ : LimitType.values()) {
            xmlToLimitType.put(((LimitType)enum_).xmlname, (LimitType)enum_);
        }
        for (Enum enum_ : WorkabilityType.values()) {
            xmlToWorkabilityType.put(((WorkabilityType)enum_).xmlname, (WorkabilityType)enum_);
        }
        for (Enum enum_ : ObjectiveType.values()) {
            xmlToObjectiveType.put(((ObjectiveType)enum_).xmlname, (ObjectiveType)enum_);
        }
        for (Enum enum_ : DiseaseType.values()) {
            xmlToDiseaseType.put(((DiseaseType)enum_).xmlname, (DiseaseType)enum_);
        }
        for (Enum enum_ : WorkerType.values()) {
            xmlToWorkerType.put(((WorkerType)enum_).xmlname, (WorkerType)enum_);
        }
        for (Enum enum_ : WorkerSubType.values()) {
            xmlToWorkerSubType.put(((WorkerSubType)enum_).xmlname, (WorkerSubType)enum_);
        }
        for (Enum enum_ : CropType.values()) {
            xmlToCropType.put(((CropType)enum_).xmlname, (CropType)enum_);
        }
        for (Enum enum_ : OperationType.values()) {
            xmlToOperationType.put(((OperationType)enum_).xmlname, (OperationType)enum_);
        }
        for (Enum enum_ : TextDataType.values()) {
            xmlToTextDataType.put(((TextDataType)enum_).xmlname, (TextDataType)enum_);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LimitType {
        AREA("area");

        public final String xmlname;

        private LimitType(String xmln) {
            this.xmlname = xmln;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum VariableType {
        NFERT("N fertiliser"),
        PFERT("P fertiliser"),
        KFERT("K fertiliser"),
        BGHERB("BGHerbicide"),
        WOHERB("WOHerbicide"),
        UNSPEC("Unspecified"),
        SIZEFIRSTMACHINE("Size of first machine in system definition"),
        PRIMARYYIELD("Primary yield of crop"),
        SECONDARYYIELD("Secondary yield of crop"),
        SEEDAMOUNTOFCROP("Seed Amount of crop"),
        SOILTYPE("Soil Type"),
        RAINFALL("Rain Fall"),
        TRANSPORT("Transport");

        public final String xmlname;

        private VariableType(String xn) {
            this.xmlname = xn;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TextDataType {
        ALLOW("allow"),
        YIELDPENALTIES("yieldpenalties"),
        COSTPENALTIES("costpenalties"),
        MINAREA("minarea"),
        HOURS("hours"),
        YIELDREDUCTION("yieldreduction"),
        DISEASE("disease"),
        ROTPENALTY("rotpenalty"),
        FORBIDDEN("forbidden"),
        WKRATE("wkrate"),
        MACHINES("machines"),
        CROPTYPE("croptype"),
        RAW("raw");

        public final String xmlname;

        private TextDataType(String xmln) {
            this.xmlname = xmln;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OperationType {
        PLOUGH("Plough", "PLGH", "plough"),
        PLANT("Plant", "PLNT", "plant"),
        BROADCAST("Broadcast", "BRDC", "broadcast"),
        ROLL("Roll", "ROLA", "roll"),
        SPRAY("Spray", "SPRA", "spray"),
        FERT("Fertilize", "FERT", "fert"),
        HARR("Harrow", "HARR", "harrow"),
        COMBINE("Combine", "COMB", "combine"),
        BALE("Bale", "BALE", "bale"),
        RIDGING("Ridging", "RDGN", "ridging"),
        HARVEST("Harvest", "HARV", "harvest"),
        HOE("Hoe", "HOE ", "hoe"),
        START("Start", "STRT", "start"),
        END("End", "END ", "end");

        public final String name;
        public final String shortName;
        public final String xmlname;

        private OperationType(String n2, String shortn, String xmln) {
            this.name = n2;
            this.shortName = shortn;
            this.xmlname = xmln;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WorkabilityType {
        R28("r28", 0.28),
        R60("r60", 0.6),
        R70("r70", 0.7),
        R80("r80", 0.8),
        R90("r90", 0.9),
        R100("r100", 1.0);

        public final String xmlname;
        public final double percentHours;

        private WorkabilityType(String xml, double pchours) {
            this.xmlname = xml;
            this.percentHours = pchours;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CropType {
        WINTERWHEAT("Winter Wheat", " WW ", "winterwheat"),
        SPRINGWHEAT("Spring Wheat", " SW ", "springwheat"),
        MIXEDWHEAT("Mixed Wheat", " MW ", "mixedwheat"),
        DURUMWHEAT("Durum Wheat", " DW ", "durumwheat"),
        TRITICALE("Triticale", "TRIT", "triticale"),
        WINTERBARLEY("Winter Barley", "WIBA", "winterbarley"),
        SPRINGBARLEY("Spring Barley", "SPBA", "springbarley"),
        MIXEDBARLEY("Mixed Barley", "MXBR", "mixedbarley"),
        WINTEROATS("Winter Oats", "WOAT", "winteroats"),
        SPRINGOATS("Spring Oats", "SOAT", "springoats"),
        MIXEDOATS("Mixed Oats", "MOAT", "mixedoats"),
        RYE("Rye", "RYE ", "rye"),
        MIXEDCEREALS("Mixed Cereals", "MCER", "mixedcereals"),
        GRAINMAIZE("Grain Maize", "MAIZ", "grainmaize"),
        FEEDBEANS("Feed Beans", "FBEA", "feedbeans"),
        FEEDPEAS("Fead Peas", "FPEA", "feedpeas"),
        DRIEDPEAS("Dried Peas", "DRPE", "driedpeas"),
        PROTEIN("Protein ", "PROT", "protein"),
        EARLYPOTATOES("Early Potatoes", "EPOT", "earlypotatoes"),
        PROCPOTATOES("Processing Potatoes", "PPOT", "procpotatoes"),
        WAREPOTATOES("Ware Potatoes", "WPOT", "warepotatoes"),
        SEEDPOTATOES("Seed Potatoes", "SPOT", "seedpotatoes"),
        MIXEDPOTATOES("Mixed Potatoes", "MXPO", "mixedpotatoes"),
        SUGARBEET("Sugar Beet", "SGBT", "sugarbeet"),
        FLAX("Flax", "FLAX", "flax"),
        LINSEED("Linseed", "LINS", "linseed"),
        WOSRNDL("Winter Oilseed Rape Not Double Low", "WOSR", "wosrndl"),
        WOSRDL("Winter Oilseed Rape Double Low", "WOSR", "wosrdl"),
        SOSRNDL("Spring Oilseed Rape Not Double Low", "SOSR", "sosrndl"),
        SOSRDL("Spring Oilseed Rape Double Low", "SOSR", "sosrdl"),
        OOSR("Other Oilseed Rape", "OOSR", "oosr"),
        OILSEEDS("Other Oilseed Crops", "OSED", "otheroilseeds"),
        HEMP("Hemp", "HEMP", "hemp"),
        HOPS("Hops", "HOPS", "hops"),
        MEDICINALS("Medicinals", "MEDS", "medicinals"),
        HERBAGESEED("Herbage Seed", "HSED", "herbageseed"),
        OTHERARABLE("Other Arable", "OARA", "otherarable"),
        MISC("Miscellaneous", "MISC", "misc"),
        WOSR("Winter OilSeed Rape", "WOSR", "wosr"),
        SOSR("Spring OilSeed Rape", "SOSR", "sosr"),
        FRESHFRUITANDVEG("Fresh Fruit and Veg", "FFVG", "freshfruitandveg"),
        ORCHARD("Orchard Fruit and Berries", "ORCH", "orchardfruit"),
        MUSHROOMS("Mushrooms", "MUSH", "mushrooms"),
        NURSERYANDFLOWERS("Nursery and Flowers", "NURS", "nurseryandflowers"),
        ENERGY("Energy Crops", "ENER", "energy"),
        GRAZING("Grass and Grazing", "GRAS", "grass"),
        FODDER("Fodder", "FODD", "fodder"),
        MISCLU("Misc Land Use", "MSCU", "misclanduse"),
        BYPRODUCTS("By Products", "BYPR", "byproducts"),
        PROCESSED("Processed Products", "PROS", "processed"),
        SUGARBEETSA("Sugar Beet SA", "SBSA", "sugarbeetsa"),
        WOSRSA("Winter Oilseed Rape SA", "WRSA", "wosrsa"),
        SOSRSA("Spring Oilseed Rape SA", "SRSA", "sosrsa"),
        OILSEEDSSA("Oilseeds SA", "OSSA", "oilseedssa"),
        OTHERARABLESA("Other Arable SA", "OASA", "otherarablesa"),
        WINTERWHEATSA("Winter Wheat SA", "WWSA", "winterwheatsa"),
        SPRINGWHEATSA("Spring Wheat SA", "SWSA", "springwheatsa"),
        LINSEEDSA("Linseed SA", "LSSA", "linseedsa"),
        MISCSA("Miscellaneous SA", "MSSA", "miscsa"),
        SPRINGBARLEYSA("Spring Barley SA", "SBSA", "springbarleysa"),
        WINTERBARLEYSA("Winter Barley SA", "WBSA", "winterbarleysa"),
        MIXEDCEREALSSA("Mixed Cereals SA", "MXSA", "mixedcerealssa"),
        FEEDBEANSSA("Feed Beans SA", "FBSA", "feedbeanssa"),
        GRAZINGSA("Grazing SA", "GRSA", "grazingsa"),
        ENERGYSA("Energy SA", "ENSA", "energysa"),
        FODDERSA("Fodder SA", "FDSA", "foddersa"),
        SETASIDE("Set Aside", "SETA", "setaside"),
        UNKNOWN("Unknown", "UNKN", "unknown"),
        SUGARBEETQUOTALEASED("Sugar Beet Quota Leased", "SBQU", "sugarbeetquotaleased"),
        SPRINGBEANS("Spring Beans", "SPBE", "springbeans"),
        WINTERBEANS("Winter Beans", "WIBE", "winterbeans");

        public final String name;
        public final String shortName;
        public final String xmlname;

        private CropType(String n2, String shortn, String xmln) {
            this.name = n2;
            this.shortName = shortn;
            this.xmlname = xmln;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WorkerSubType {
        LABOUR("Labour", "LABR", "labour"),
        FARMER("Farmer", "FRMR", "farmer"),
        HARVESTER("Combine", "COMB", "combine"),
        TRACTOR("Tractor", "TRAC", "tractor"),
        SPRAYER("Sprayer", "SPYR", "sprayer"),
        COMBINE("Combine", "CMBN", "combine"),
        BALER("Baler", "BALR", "baler"),
        HARROW("Power Harrow", "HARR", "powerharrow"),
        POTHARV("Potato Harvester", "PHAR", "potato-harvester"),
        SBHARV("SugarBeet Harvester", "SBHA", "sugarbeet-harvester");

        public final String name;
        public final String shortName;
        public final String xmlname;

        private WorkerSubType(String n2, String shortn, String xmln) {
            this.name = n2;
            this.shortName = shortn;
            this.xmlname = xmln;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WorkerType {
        LABOUR("Labour", "LABR", "labour", 0.0, 1.0),
        TRACTOR("Tractor", "TRAC", "tractor", 140.0, 100.0),
        SPRAYER("Sprayer", "SPYR", "sprayer", 20.0, 2000.0),
        COMBINE("Combine", "CMBN", "combine", 168.0, 14.0),
        BALER("Baler", "BALR", "baler", 50.0, 5.0),
        HARROW("Power Harrow", "HARR", "powerharrow", 0.0, 100.0),
        POTHARV("Potato Harvester", "PHAR", "potato-harvester", 50.0, 100.0),
        SBHARV("SugarBeet Harvester", "SBHA", "sugarbeet-harvester", 70.0, 100.0),
        NOMACHINE("No Machine", "NONE", "no-machine", 0.0, 0.0);

        public final String name;
        public final String shortName;
        public final String xmlname;
        public final double power;
        public final double size;

        public double litresPerHour() {
            return 0.16 * this.power;
        }

        private WorkerType(String n2, String shortn, String xmln, double pow, double sze) {
            this.name = n2;
            this.shortName = shortn;
            this.xmlname = xmln;
            this.power = pow;
            this.size = sze;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DiseaseType {
        WHEAT("wheat"),
        OATS("oats"),
        BARLEY("barley"),
        BRASSICA("brassica"),
        POTATOES("potatoes"),
        SUGARBEET("sugarbeet"),
        SETASIDE("setaside"),
        DRIEDPEAS("driedpeas"),
        PEASBEANS("peasbeans"),
        LINSEED("linseed"),
        NONE("none");

        public final String xmlname;

        private DiseaseType(String name_) {
            this.xmlname = name_;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ELSCode {
        EB1("Hedgerow management both sides", "eb1", ModelComponent.MCType.ELSBOUNDARIES, 220.0),
        EB2("Hedgerow management one side", "eb2", ModelComponent.MCType.ELSBOUNDARIES, 110.0),
        EB3("Enhanced hedgerow management", "eb3", ModelComponent.MCType.ELSBOUNDARIES, 420.0),
        EB6("Ditch management", "eb6", ModelComponent.MCType.ELSBOUNDARIES, 240.0),
        EB10("Combined hedge and ditch management", "eb10", ModelComponent.MCType.ELSBOUNDARIES, 560.0),
        EF6("Overwintered stubbles", "ef6", ModelComponent.MCType.STUBBLES, 120.0),
        EE3("6m buffer strips", "ee3", ModelComponent.MCType.FIELDMARGINS, 400.0),
        EE2("4m buffer strips", "ee2", ModelComponent.MCType.FIELDMARGINS, 400.0),
        EF1("Field corner management", "ef1", ModelComponent.MCType.FIELDMARGINS, 400.0);

        String description;
        public final double defaultPoints;
        public final String xmlname;
        public ModelComponent.MCType parentComponentType;

        private ELSCode(String description_, String name_, ModelComponent.MCType mctype_, double defaultPoints_) {
            this.description = description_;
            this.xmlname = name_;
            this.defaultPoints = defaultPoints_;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ObjectiveType {
        PROFIT("profit"),
        CURVEDPROFIT("curvedprofit"),
        WINTERSTUBBLE("winterstubble"),
        CURVEDWINTERSTUBBLE("curvedwinterstubble"),
        CURVEDCROPCOMPLEXITY("curvedcropcomplexity"),
        CROPCOMPLEXITY("cropcomplexity"),
        HEDGEROWS("hedgerows"),
        CURVEDHEDGEROWS("curvedhedgerows"),
        FREETIME("freetime"),
        CURVEDFREETIME("curvedfreetime"),
        MOTADRISK("motadrisk"),
        VARRISK("varrisk"),
        CURVEDVARRISK("curvedvarrisk"),
        CURVEDMOTADRISK("curvedmotadrisk"),
        ELSCOMPLEXITY("elscomplexity"),
        CURVEDELSCOMPLEXITY("curvedelscomplexity"),
        DITCHES("ditches"),
        CURVEDDITCHES("curvedditches"),
        SOS2DUMMY("sos2dummy");

        public final String xmlname;

        private ObjectiveType(String name) {
            this.xmlname = name;
        }
    }
}

