/*
 * Decompiled with CFR 0.152.
 */
package jfm.model;

import java.util.ArrayList;

public class FormulaParser {
    private BranchNode root = new BranchNode();

    public FormulaParser(String input) {
        this.root.parse(input);
    }

    private String getBracedVariable(String fString, int ci) {
        int openBracketCount = 1;
        for (int i = ci; i < fString.length(); ++i) {
            char c = fString.charAt(i);
            if (c == '{') {
                ++openBracketCount;
            }
            if (c == '}') {
                --openBracketCount;
            }
            if (openBracketCount != 0) continue;
            return fString.substring(ci, i);
        }
        throw new Error("Reached End of String but no closing brace found");
    }

    private String getBracket(String fString, int ci) {
        int openBracketCount = 1;
        for (int i = ci; i < fString.length(); ++i) {
            char c = fString.charAt(i);
            if (c == '(') {
                ++openBracketCount;
            }
            if (c == ')') {
                --openBracketCount;
            }
            if (openBracketCount != 0) continue;
            return fString.substring(ci, i);
        }
        throw new Error("Reached End of String but no closing bracket found");
    }

    private String getNumber(String fString, int ci) {
        for (int i = ci; i < fString.length(); ++i) {
            char c = fString.charAt(i);
            if (Character.isDigit(c) || c == '.') continue;
            return fString.substring(ci, i);
        }
        return fString.substring(ci);
    }

    private class BranchNode
    extends Node {
        FOperator op;
        Node LHS;
        Node RHS;

        private BranchNode() {
        }

        public void parse(String fString) {
            int i;
            ArrayList<String> operands = new ArrayList<String>();
            ArrayList<FOperator> operators = new ArrayList<FOperator>();
            block11: for (int ci = 0; ci < fString.length(); ++ci) {
                char c = fString.charAt(ci);
                if (Character.isDigit(c) || c == '.') {
                    String number = FormulaParser.this.getNumber(fString, ci);
                    operands.add(number);
                    c = fString.charAt(ci += number.length() + 1);
                }
                switch (c) {
                    case '(': {
                        String brac = FormulaParser.this.getBracket(fString, ci + 1);
                        operands.add(brac);
                        ci += brac.length() + 1;
                        continue block11;
                    }
                    case ')': {
                        throw new Error("Unopened close bracket encountered in formula");
                    }
                    case '{': {
                        String brace = FormulaParser.this.getBracedVariable(fString, ci + 1);
                        operands.add(brace);
                        ci += brace.length() + 1;
                        continue block11;
                    }
                    case '}': {
                        throw new Error("Unopened close brace encountered in formula");
                    }
                    case '^': {
                        operators.add(FOperator.POWER);
                        continue block11;
                    }
                    case '*': {
                        operators.add(FOperator.TIMES);
                        continue block11;
                    }
                    case '/': {
                        operators.add(FOperator.DIVIDE);
                        continue block11;
                    }
                    case '-': {
                        operators.add(FOperator.MINUS);
                        continue block11;
                    }
                    case '+': {
                        operators.add(FOperator.PLUS);
                        continue block11;
                    }
                    default: {
                        throw new Error("Unrecognised character in formula" + c);
                    }
                }
            }
            if (operators.size() + 1 != operands.size()) {
                throw new Error("There must be exactly one fewer operators than operands");
            }
            if (operators.size() == 0) {
                throw new Error("Branch Node must have at least one operator");
            }
            int separatingOp = operators.indexOf((Object)FOperator.PLUS);
            if (separatingOp == -1) {
                separatingOp = operators.indexOf((Object)FOperator.MINUS);
            }
            if (separatingOp == -1) {
                separatingOp = operators.indexOf((Object)FOperator.TIMES);
            }
            if (separatingOp == -1) {
                separatingOp = operators.indexOf((Object)FOperator.DIVIDE);
            }
            if (separatingOp == -1) {
                separatingOp = operators.indexOf((Object)FOperator.POWER);
            }
            if (separatingOp == -1) {
                throw new Error("No separating operation");
            }
            StringBuffer lstrbuff = new StringBuffer();
            StringBuffer rstrbuff = new StringBuffer();
            lstrbuff.append((String)operands.get(0));
            for (i = 1; i <= separatingOp; ++i) {
                lstrbuff.append(((FOperator)((Object)operators.get((int)(i - 1)))).token);
                lstrbuff.append((String)operands.get(i));
            }
            rstrbuff.append((String)operands.get(separatingOp + 1));
            for (i = separatingOp + 2; i < operands.size(); ++i) {
                rstrbuff.append(((FOperator)((Object)operators.get((int)(i - 1)))).token);
                rstrbuff.append((String)operands.get(i));
            }
            this.assignNode(lstrbuff.toString(), this.LHS);
            this.assignNode(rstrbuff.toString(), this.RHS);
        }
    }

    private class LeafNode
    extends Node {
        public double value;

        private LeafNode() {
            this.value = 0.0;
        }

        public void parse(String fString) {
            this.value = Double.parseDouble(fString);
        }
    }

    private abstract class Node {
        private Node() {
        }

        abstract void parse(String var1);

        private boolean isBranchNode(String str) {
            return str.contains("*") || str.contains("-") || str.contains("+") || str.contains("/") || str.contains("^");
        }

        void assignNode(String str, Node theNode) {
            theNode = this.isBranchNode(str) ? new BranchNode() : new LeafNode();
            theNode.parse(str);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum NodeType {
        BRANCH,
        LEAF;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum FOperator {
        TIMES('*'),
        MINUS('-'),
        PLUS('+'),
        DIVIDE('/'),
        POWER('^');

        char token;

        private FOperator(char t) {
            this.token = t;
        }

        public static FOperator charToOp(char c) {
            switch (c) {
                case '*': {
                    return TIMES;
                }
                case '/': {
                    return DIVIDE;
                }
                case '-': {
                    return MINUS;
                }
                case '+': {
                    return PLUS;
                }
                case '^': {
                    return POWER;
                }
            }
            throw new Error("The operator " + c + "is not recognised");
        }

        public double operate(double lhs, double rhs) {
            switch (this.token) {
                case '*': {
                    return lhs * rhs;
                }
                case '/': {
                    return lhs / rhs;
                }
                case '-': {
                    return lhs - rhs;
                }
                case '+': {
                    return lhs + rhs;
                }
                case '^': {
                    return Math.pow(lhs, rhs);
                }
            }
            throw new Error("token for " + (Object)((Object)this) + " is not a mathematical operator");
        }
    }
}

