% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ParseSettings.R
\name{.parse_file_paths}
\alias{.parse_file_paths}
\title{Internal function for parsing file paths}
\usage{
.parse_file_paths(
  config = NULL,
  project_dir = waiver(),
  experiment_dir = waiver(),
  data_file = waiver(),
  verbose = TRUE,
  ...
)
}
\arguments{
\item{config}{A list of settings, e.g. from an xml file.}

\item{project_dir}{(\emph{optional}) Path to the project directory. \code{familiar}
checks if the directory indicated by \code{experiment_dir} and data files in
\code{data_file} are relative to the \code{project_dir}.}

\item{experiment_dir}{(\strong{recommended}) Path to the directory where all
intermediate and final results produced by \code{familiar} are written to.

The \code{experiment_dir} can be a path relative to \code{project_dir} or an absolute
path.

In case no project directory is provided and the experiment directory is
not on an absolute path, a directory will be created in the temporary R
directory indicated by \code{tempdir()}. This directory is deleted after closing
the R session or once data analysis has finished. All information will be
lost afterwards. Hence, it is recommended to provide either
\code{experiment_dir} as an absolute path, or provide both \code{project_dir} and
\code{experiment_dir}.}

\item{data_file}{(\emph{optional}) Path to files containing data that should be
analysed. The paths can be relative to \code{project_dir} or absolute paths. An
error will be raised if the file cannot be found.

The following types of data are supported.
\itemize{
\item \code{csv} files containing column headers on the first row, and samples per
row. \code{csv} files are read using \code{data.table::fread}.
\item \code{rds} files that contain a \code{data.table} or \code{data.frame} object. \code{rds}
files are imported using \code{base::readRDS}.
\item \code{RData} files that contain a single \code{data.table} or \code{data.frame} object.
\code{RData} files are imported using \code{base::load}.
}

All data are expected in wide format, with sample information organised
row-wise.

More than one data file can be provided. \code{familiar} will try to combine
data files based on column names and identifier columns.

Alternatively, data can be provided using the \code{data} argument. These data
are expected to be \code{data.frame} or \code{data.table} objects or paths to data
files. The latter are handled in the same way as file paths provided to
\code{data_file}.}

\item{verbose}{Sets verbosity.}

\item{...}{Unused arguments}
}
\value{
List of paths to important directories and files.
}
\description{
Internal function for parsing file paths
}
\keyword{internal}
