% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{cortimeplot}
\alias{cortimeplot}
\alias{covtimeplot}
\title{Plot correlations over time.}
\usage{
cortimeplot(
  x,
  series,
  these = seq_len(nrow(x$y)),
  type = "cor",
  statistic = "mean"
)

covtimeplot(
  x,
  series,
  these = seq_len(nrow(x$y)),
  type = "cov",
  statistic = "mean"
)
}
\arguments{
\item{x}{Object of class \code{'fsvdraws'}, usually resulting from a call
to \code{\link{fsvsample}}.}

\item{series}{Single number, coercible to integer. Indicates the series
relative to which correlations are drawn.}

\item{these}{Index vector containing the time points to plot. Defaults
to \code{seq_len(nrow(x$y))}.}

\item{type}{What to plot, usually "cor" or "cov".}

\item{statistic}{Which posterior summary should be plotted, usually "mean".}
}
\value{
Returns \code{x} invisibly.
}
\description{
\code{cortimeplot} draws correlations over time.
}
\details{
This function displays one component series' time-varying correlations with
the other components series. Throws an error if correlations haven't been
stored during sampling.
}
\seealso{
Other plotting: 
\code{\link{comtimeplot}()},
\code{\link{corimageplot}()},
\code{\link{corplot}()},
\code{\link{facloadcredplot}()},
\code{\link{facloaddensplot}()},
\code{\link{facloadpairplot}()},
\code{\link{facloadpointplot}()},
\code{\link{facloadtraceplot}()},
\code{\link{logvartimeplot}()},
\code{\link{paratraceplot}()},
\code{\link{plot.fsvdraws}()},
\code{\link{plotalot}()},
\code{\link{voltimeplot}()}
}
\concept{plotting}
