% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.eyeris.R
\name{plot_gaze_heatmap}
\alias{plot_gaze_heatmap}
\title{Create gaze heatmap of eye coordinates}
\usage{
plot_gaze_heatmap(
  eyeris,
  block = 1,
  screen_width = NULL,
  screen_height = NULL,
  n_bins = 50,
  col_palette = "viridis",
  main = "Gaze Heatmap",
  xlab = "Screen X (pixels)",
  ylab = "Screen Y (pixels)",
  sample_rate = NULL,
  eye_suffix = NULL
)
}
\arguments{
\item{eyeris}{An object of class \code{eyeris} derived from \code{\link[=load_asc]{load_asc()}}}

\item{block}{Block number to plot (default: 1)}

\item{screen_width}{Screen width in pixels from \code{eyeris$info$screen.x}}

\item{screen_height}{Screen height in pixels from \code{eyeris$info$screen.y}}

\item{n_bins}{Number of bins for the heatmap grid (default: 50)}

\item{col_palette}{Color palette for the heatmap (default: "viridis")}

\item{main}{Title for the plot (default: "Fixation Heatmap")}

\item{xlab}{X-axis label (default: "Screen X (pixels)")}

\item{ylab}{Y-axis label (default: "Screen Y (pixels)")}

\item{sample_rate}{Sample rate in Hz (optional)}

\item{eye_suffix}{Eye suffix for binocular data (default: NULL)}
}
\value{
No return value; creates a heatmap plot
}
\description{
Creates a heatmap showing the distribution of eye_x and eye_y coordinates
across the entire screen area. The heatmap shows where the participant
looked most frequently during the recording period.
}
\examples{
demo_data <- eyelink_asc_demo_dataset()
eyeris_preproc <- glassbox(demo_data)
plot_gaze_heatmap(eyeris = eyeris_preproc, block = 1)

}
