% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dev.R
\name{dev_beta_binom}
\alias{dev_beta_binom}
\title{Beta-Binomial Deviances}
\usage{
dev_beta_binom(x, size = 1, prob = 0.5, theta = 0, res = FALSE)
}
\arguments{
\item{x}{A non-negative whole numeric vector of values.}

\item{size}{A non-negative whole numeric vector of the number of trials.}

\item{prob}{A numeric vector of values between 0 and 1 of the probability of success.}

\item{theta}{A non-negative numeric vector of the dispersion for the mixture models (student, gamma-Poisson and beta-binomial).}

\item{res}{A flag specifying whether to return the deviance residual as opposed to the deviance.}
}
\value{
An numeric vector of the corresponding deviances or deviance residuals.
}
\description{
This parameterization of the beta-binomial distribution uses an expected probability parameter, \code{prob}, and a dispersion parameter, \code{theta}. The parameters of the underlying beta mixture are \code{alpha = (2 * prob) / theta} and \code{beta = (2 * (1 - prob)) / theta}. This parameterization of \code{theta} is unconventional, but has useful properties when modelling. When \code{theta = 0}, the beta-binomial reverts to the binomial distribution. When \code{theta = 1} and \code{prob = 0.5}, the parameters of the beta distribution become \code{alpha = 1} and \code{beta = 1}, which correspond to a uniform distribution for the beta-binomial probability parameter.
}
\examples{
dev_beta_binom(c(0, 1, 2), 1, 0.5, 0)
}
\seealso{
Other dev_dist: 
\code{\link{dev_bern}()},
\code{\link{dev_binom}()},
\code{\link{dev_gamma_pois}()},
\code{\link{dev_gamma}()},
\code{\link{dev_lnorm}()},
\code{\link{dev_neg_binom}()},
\code{\link{dev_norm}()},
\code{\link{dev_pois_zi}()},
\code{\link{dev_pois}()},
\code{\link{dev_student}()}
}
\concept{dev_dist}
