% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extr_pubchem.R
\name{extr_pubchem_fema}
\alias{extr_pubchem_fema}
\title{Extract FEMA from PubChem}
\usage{
extr_pubchem_fema(casrn, verbose = TRUE, delay = 0)
}
\arguments{
\item{casrn}{A vector of CAS Registry Numbers (CASRN) as atomic vectors.}

\item{verbose}{A logical value indicating whether to print detailed messages.
Default is TRUE.}

\item{delay}{A numeric value indicating the delay (in seconds) between API
requests. This controls the time between successive PubChem queries.
Default is 0. See Details for more info.}
}
\value{
A data frame containing the FEMA flavor profile information for each
CASRN. If no information is found for a particular CASRN, the output will
include a row indicating this.
}
\description{
This function retrieves FEMA (Flavor and Extract Manufacturers Association)
flavor profile information for a list of CAS Registry Numbers (CASRN) from
the PubChem database using the \code{webchem} package.
}
\details{
The function performs two queries to PubChem:
\enumerate{
\item The first query retrieves the PubChem Compound Identifier (CID) for each
IUPAC name.
\item The second query retrieves additional information using the
obtained CIDs.
In cases of multiple rapid successive requests, the PubChem server may
deny access. Introducing a delay between requests (using the \code{delay}
parameter) can help prevent this issue.
}
}
\examples{
\donttest{
extr_pubchem_fema(c("83-67-0", "1490-04-6"))
}
}
\seealso{
\href{https://pubchem.ncbi.nlm.nih.gov/}{PubChem}
}
