% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bernoulli-distribution.R
\name{Bernoulli}
\alias{Bernoulli}
\alias{dbern}
\alias{pbern}
\alias{qbern}
\alias{rbern}
\title{Bernoulli distribution}
\usage{
dbern(x, prob = 0.5, log = FALSE)

pbern(q, prob = 0.5, lower.tail = TRUE, log.p = FALSE)

qbern(p, prob = 0.5, lower.tail = TRUE, log.p = FALSE)

rbern(n, prob = 0.5)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{prob}{probability of success; (\code{0 < prob < 1}).}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P[X \le x]}
otherwise, \eqn{P[X > x]}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1},
the length is taken to be the number required.}
}
\description{
Probability mass function, distribution function, quantile function and random generation
for the Bernoulli distribution.
}
\examples{

prop.table(table(rbern(1e5, 0.5)))

}
\seealso{
\code{\link[stats]{Binomial}}
}
\keyword{distribution}

