% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_separate.R
\name{split_by}
\alias{split_by}
\alias{split_off}
\alias{split_separate}
\title{Splits data.frame into list of data.frames that can be analyzed separately}
\usage{
split_by(data, ..., drop = TRUE)

split_off(data, groups = NULL, rownames = NULL)

split_separate(data, ..., drop = TRUE)
}
\arguments{
\item{data}{data.frame for \code{split_by}/list for \code{split_off}}

\item{...}{unquoted variables names (see \link{keep}) by which \code{data}
will be split into list.}

\item{drop}{should we drop combination of levels with zero observation? TRUE
by default.}

\item{groups}{character If it is not \code{NULL} then we add list
names as variable to result of \code{split_off} with the name specified by
\code{groups}. If it is \code{TRUE} then name will be \code{.groups}.}

\item{rownames}{character If it is not \code{NULL} then we add data.frames
rownames as variable to result of \code{split_off} with the name specified
by \code{rownames}. If it is \code{TRUE} then name will be 
\code{.rownames}.}
}
\value{
\code{split_by} returns list of data.frames/\code{split_off}
  returns data.frame
}
\description{
Splits data.frame into list of data.frames that can be analyzed separately.
These data.frames are sets of cases that have the same values for the
specified split variables. Any missing values in split variables are dropped
together with the corresponding values of \code{data}. \code{split_off} works
with lists of data.frames or objects that can be coerced to data.frame and
assumed to have compatible structure. Resulting rows will be sorted in order
of the split variables. \code{split_separate} is an alias to \code{split_by}.
}
\examples{
# example from base R 'split'
data(airquality)
airquality2 = airquality \%>\% 
    split_by(Month) \%>\% 
    compute({
        Ozone_zscore = scale(Ozone)
    }) \%>\% 
    split_off() 
    
head(airquality2)

# usage of 'groups', 'rownames'
data(mtcars)
# add labels to dataset
mtcars \%>\% 
    apply_labels(mpg = "Miles/(US) gallon",
                 disp = "Displacement (cu.in.)",
                 wt = "Weight",
                 hp = "Gross horsepower",
                 vs = "Engine",
                 vs = num_lab(" 
                                   0 V-engine
                                   1 Straight engine
                                   "),
                 
                 am = "Transmission",
                 am = num_lab(" 
                                   0 Automatic
                                   1 Manual
                                   ")
    ) \%>\% 
    split_by(am, vs) \%>\% 
    use_labels({
        res = lm(mpg ~ hp + disp + wt)
        cbind(Coef. = coef(res), confint(res))
    }) \%>\% 
    split_off(groups = TRUE, rownames = "variable")
}
\seealso{
\link[base]{split}, \link{compute}, \link{calculate},
  \link{do_repeat}, \link{where}
}
