% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_repeat.R
\name{do_repeat}
\alias{do_repeat}
\alias{do_repeat}
\alias{.do_repeat}
\title{Repeats the same transformations on a specified set of variables/values}
\usage{
do_repeat(data, ...)

.do_repeat(...)
}
\arguments{
\item{data}{data.frame/list. If \code{data} is list then \code{do_repeat}
will be applied to each element of the list.}

\item{...}{stand-in name(s) followed by equals sign and a vector of 
replacement variables or values. Characters considered as variables names, 
all other types considered as is. Last argument should be expression in 
curly brackets which will be evaluated in the scope of data.frame 
\code{data}. See examples.}
}
\value{
transformed data.frame \code{data}
}
\description{
Repeats the same transformations on a specified set of variables/values
}
\details{
There is a special constant \code{.N} which equals to number of 
  cases in \code{data} for usage in expression inside \code{do_repeat}. Also 
  there is a variable \code{.item_num} which is equal to the current
  iteration number.
}
\examples{
data(iris)
scaled_iris = do_repeat(iris, 
                        i = qc(Sepal.Length, Sepal.Width, Petal.Length, Petal.Width), 
                        {
                            i = scale(i)
                        })
head(scaled_iris)

# several stand-in names
old_names = qc(Sepal.Length, Sepal.Width, Petal.Length, Petal.Width)
new_names = paste0("scaled_", old_names)
scaled_iris = do_repeat(iris, 
                        orig = old_names, 
                        scaled = new_names, 
                        {
                            scaled = scale(orig)
                        })
head(scaled_iris)

# numerics
new_df = data.frame(id = 1:20)
new_df = do_repeat(new_df, 
                   item = qc(i1, i2, i3), 
                   value = c(1, 2, 3), 
                   {
                       item = value
                   })
head(new_df)

# the same result with internal variable '.item_num'
new_df = data.frame(id = 1:20)
new_df = do_repeat(new_df, 
                   item = qc(i1, i2, i3),
                   {
                       item = .item_num
                   })
head(new_df)

# functions
set.seed(123)
new_df = data.frame(id = 1:20)
new_df = do_repeat(new_df, 
                   item = qc(i1, i2, i3), 
                   fun = c("rnorm", "runif", "rexp"), 
                   {
                       item = fun(.N)
                   })
head(new_df)


}
\seealso{
\link{compute}, \link{do_if}
}
