% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/6-predict.R, R/8.2-ens.R
\docType{methods}
\name{exprso-predict}
\alias{exprso-predict}
\alias{predict,ExprsMachine-method}
\alias{predict,ExprsModule-method}
\alias{predict,ExprsEnsemble-method}
\title{Predict Class Labels}
\usage{
\S4method{predict}{ExprsMachine}(object, array, verbose = TRUE)

\S4method{predict}{ExprsModule}(object, array, verbose = TRUE)

\S4method{predict}{ExprsEnsemble}(object, array, how = "probability",
  verbose = TRUE)
}
\arguments{
\item{object}{An \code{ExprsModel} object or an \code{ExprsEnsemble} object.
The classifier to deploy.}

\item{array}{An \code{ExprsArray} object. The validation set.}

\item{verbose}{A logical scalar. Toggles whether to print from
\code{calcStats}.}

\item{how}{A character string. Select from "probability" or "majority".
See Details for the implication of this choice. Argument applies to
\code{ExprsEnsemble} prediction only.}
}
\value{
Returns an \code{ExprsPredict} object.
}
\description{
Predict class labels of a validation set.
}
\details{
For an \code{ExprsMachine}:

An \code{ExprsMachine} object can only predict against an \code{ExprsBinary}
 object. An \code{ExprsModule} object can only predict against an
 \code{ExprsMulti} object. The validation set should never get modified
 once separated from the training set. If the training set used to build
 an \code{ExprsModule} had a class missing (i.e., has an NA placeholder),
 the \code{ExprsModule} cannot predict the missing class. To learn how
 this scenario gets handled, read more at \code{\link{doMulti}}.

\code{ExprsPredict} objects store predictions in three slots: \code{@pred},
 \code{@decision.values}, and \code{@probability}. The first slot
 stores a "final decision" based on the class label with the maximum
 predicted probability. The second slot stores a transformation
 of the predicted probability for each class calculated by the inverse
 of Platt scaling. The predicted probability gets returned by the
 \code{predict} method called using the stored \code{@mach} object.
 To learn how these slots get used to calculate classifier performance,
 read more at \code{\link{calcStats}}.

For an \code{ExprsEnsemble}:

At the moment, \code{ExprsEnsemble} can only make predictions
 using \code{ExprsMachine} objects. Therefore, it can only predict
 against \code{ExprsBinary} objects. Predicting with ensembles poses
 a unique challenge with regard to how to translate multiple
 performance scores (one for each classifier in the ensemble) into
 a single performance score (for the ensemble as a whole). For now,
 the \code{ExprsEnsemble} \code{predict} method offers two options,
 toggled with the argument \code{how}. Regardless of the chosen
 \code{how}, \code{buildEnsemble} begins by deploying each constituent
 classifier on the validation set to yield a list of \code{ExprsPredict}
 objects.

When \code{how = "probability"}, this method will take the average
 predicted class probability (i.e., \code{@probability} for each
 returned \code{ExprsPredict} object (corresponding to each constituent
 \code{ExprsModel} object). When \code{how = "majority"}, this method
 will let the final decision from each returned \code{ExprsPredict}
 object (i.e., \code{@pred}) cast a single (all-or-nothing) vote.
 Each subject gets assigned the class that received the most number
 of votes (i.e., winner takes all). In both scenarios, ties get
 broken randomly with equal weights given to each class.
}
\seealso{
\code{\link{modHistory}}, \code{\link{calcStats}}
}
