% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explor.R, R/explor_multi_CA.R,
%   R/explor_multi_MCA.R, R/explor_multi_PCA.R
\name{explor}
\alias{explor}
\alias{explor.CA}
\alias{explor.textmodel_ca}
\alias{explor.coa}
\alias{explor.MCA}
\alias{explor.speMCA}
\alias{explor.mca}
\alias{explor.acm}
\alias{explor.PCA}
\alias{explor.princomp}
\alias{explor.prcomp}
\alias{explor.pca}
\title{Interface for analysis results exploration}
\usage{
explor(obj)

\method{explor}{CA}(obj)

\method{explor}{textmodel_ca}(obj)

\method{explor}{coa}(obj)

\method{explor}{MCA}(obj)

\method{explor}{speMCA}(obj)

\method{explor}{mca}(obj)

\method{explor}{acm}(obj)

\method{explor}{PCA}(obj)

\method{explor}{princomp}(obj)

\method{explor}{prcomp}(obj)

\method{explor}{pca}(obj)
}
\arguments{
\item{obj}{object containing analysis results}
}
\value{
The function launches a shiny app in the system web browser.
}
\description{
This function launches a shiny app in a web browser in order to do
interactive visualisation and exploration of an analysis results.
}
\details{
If you want to display supplementary individuals or variables and you're using
the \code{\link[ade4]{dudi.coa}} function, you can add the coordinates of 
\code{\link[ade4]{suprow}} and/or \code{\link[ade4]{supcol}} to as \code{supr} and/or 
\code{supr} elements added to your \code{\link[ade4]{dudi.coa}} result (See example).

If you want to display supplementary individuals or variables and you're using
the \code{\link[ade4]{dudi.acm}} function, you can add the coordinates of
\code{\link[ade4]{suprow}} and/or \code{\link[ade4]{supcol}} to as \code{supi} and/or
\code{supv} elements added to your \code{\link[ade4]{dudi.acm}} result (See example).

If you want to display supplementary individuals or variables and you're using
the \code{\link[ade4]{dudi.pca}} function, you can add the coordinates of 
\code{\link[ade4]{suprow}} and/or \code{\link[ade4]{supcol}} to as \code{supi} and/or 
\code{supv} elements added to your \code{\link[ade4]{dudi.pca}} result (See example).
}
\examples{
\dontrun{

require(FactoMineR)

## FactoMineR::MCA exploration
data(hobbies)
mca <- MCA(hobbies[1:1000,c(1:8,21:23)], quali.sup = 9:10, 
           quanti.sup = 11, ind.sup = 1:100, graph = FALSE)
explor(mca)

## FactoMineR::PCA exploration
data(decathlon)
d <- decathlon[,1:12]
pca <- PCA(d, quanti.sup = 11:12, graph = FALSE)
explor(pca)
}
\dontrun{

library(ade4)

data(bordeaux)
tab <- bordeaux
row_sup <- tab[5,-4]
col_sup <- tab[-5,4]
coa <- dudi.coa(tab[-5,-4], nf = 5, scannf = FALSE)
coa$supr <- suprow(coa, row_sup)
coa$supc <- supcol(coa, col_sup)
explor(coa)
}
\dontrun{

library(ade4)
data(banque)
d <- banque[-(1:100),-(19:21)]
ind_sup <- banque[1:100, -(19:21)]
var_sup <- banque[-(1:100),19:21]
acm <- dudi.acm(d, scannf = FALSE, nf = 5)
acm$supv <- supcol(acm, dudi.acm(var_sup, scannf = FALSE, nf = 5)$tab)
colw <- acm$cw*ncol(d)
X <- acm.disjonctif(ind_sup)
X <- data.frame(t(t(X)/colw) - 1)
acm$supi <- suprow(acm, X)
explor(acm)
}
\dontrun{

library(ade4)
data(deug)
d <- deug$tab
sup_var <- d[-(1:10), 8:9]
sup_ind <- d[1:10, -(8:9)]
pca <- dudi.pca(d[-(1:10), -(8:9)], scale = TRUE, scannf = FALSE, nf = 5)
supi <- suprow(pca, sup_ind)
pca$supi <- supi
supv <- supcol(pca, dudi.pca(sup_var, scale = TRUE, scannf = FALSE)$tab)
pca$supv <- supv
explor(pca)
}
}
