% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic.R
\name{summary.expirest_wisle}
\alias{summary.expirest_wisle}
\title{Summary of the what-if shelf life estimation (wisle)}
\usage{
\method{summary}{expirest_wisle}(object, ...)
}
\arguments{
\item{object}{An object of class \sQuote{\code{expirest_wisle}} returned
by the \code{\link{expirest_wisle}()} function.}

\item{...}{Further arguments passed to or from other methods or arguments
that can be passed down to the \code{\link[base]{formatC}()} function.}
}
\value{
The \sQuote{\code{expirest_wisle}} object passed to the
\code{object} parameter is returned invisibly.
}
\description{
This is a method for the function \code{summary()} for objects of class
\sQuote{\code{expirest_wisle}}.
}
\details{
The function \code{\link{expirest_wisle}()} estimates the expiry
for the specified release and specification limit following the ARGPM
guidance \dQuote{Stability testing for prescription medicines}. By default,
batch poolability is checked as recommended by the ICH Q1E guideline at a
significance level of 0.25. Other levels can be used, although not
recommended, by changing the default of the \code{alpha_pool} parameter.
Three possible models may be appropriate, i.e.
\itemize{
 \item a \emph{common intercept / common slope} model (cics),
 \item a \emph{different intercept / common slope} model (dics) or
 \item a \emph{different intercept / different slope} model (dids).
}

The worst case intercept is the intercept of the batch whose confidence
limit is the first crossing the acceptance limit. As in case of the
\code{cics} model type all batches have a common intercept and a common
confidence interval, all batches can be regarded as equally worst case. In
case of the \code{dids} model type, shelf life estimation is done using the
models obtained from fitting the data of each batch individually. In
addition to the shelf life estimated according to the ARGPM also the
estimate according to ICH Q1E is shown.
}
\examples{
# Fit models of different type
res1 <-
  expirest_wisle(data = exp1[exp1$Batch \%in\% c("b2", "b5", "b7"), ],
                 response_vbl = "Potency", time_vbl = "Month",
                 batch_vbl = "Batch", rl = 98, rl_sf = 3, sl = 95,
                 sl_sf = 3, srch_range = c(0, 500), sf_option = "loose")

res2 <-
  expirest_wisle(data = exp1[exp1$Batch \%in\% c("b3", "b4", "b5"), ],
                 response_vbl = "Potency", time_vbl = "Month",
                 batch_vbl = "Batch", rl = 98, rl_sf = 3, sl = 95,
                 sl_sf = 3, srch_range = c(0, 500), sf_option = "loose")
res3 <-
  expirest_wisle(data = exp1[exp1$Batch \%in\% c("b4", "b5", "b8"), ],
                 response_vbl = "Potency", time_vbl = "Month",
                 batch_vbl = "Batch", rl = 98, rl_sf = 3, sl = 95,
                 sl_sf = 3, srch_range = c(0, 500), sf_option = "loose")

# The parameter settings sf_option = "loose" and ivl_side = "lower" (the
# default setting of ivl_side) cause the specification limit of 95.0
# (sl_sf = 3, i.e. 3 significant digits) to be reduced by 0.05, i.e. the
# actual specification limit is 94.95.

\dontrun{
  summary(res1)
  # Expected output of summary(res1)
  # Summary of shelf life estimation following the ARGPM
  # guidance "Stability testing for prescription medicines"
  #
  # The best model accepted at a significance level of 0.25 has
  # Common intercepts and Common slopes (acronym: cics).
  #
  # Worst case intercept and batch:
  #   RL Batch Intercept
  # 1 98    NA  100.5669
  #
  # Estimated shelf lives for the cics model:
  #   SL RL    wisle    osle
  # 1 95 98 14.07398 26.2241
  #
  # Abbreviations:
  #   ARGPM: Australian Regulatory Guidelines for Prescription Medicines;
  #   ICH: International Council for Harmonisation;
  #   osle: Ordinary shelf life estimation (i.e. following the ICH guidance);
  #   RL: Release Limit;
  #   SL: Specification Limit;
  #   wisle: What-if (approach for) shelf life estimation (see ARGPM guidance).

  summary(res2)
  # Expected output of summary(res2)
  # Summary of shelf life estimation following the ARGPM
  # guidance "Stability testing for prescription medicines"
  #
  # The best model accepted at a significance level of 0.25 has
  # Different intercepts and Common slopes (acronym: dics).
  #
  # Worst case intercept and batch:
  #   RL Batch Intercept
  # 1 98    b5    100.82
  #
  # Estimated shelf lives for the dics model:
  #   SL RL    wisle     osle
  # 1 95 98 11.40993 23.60194
  #
  # Abbreviations:
  #   ARGPM: Australian Regulatory Guidelines for Prescription Medicines;
  #   ICH: International Council for Harmonisation;
  #   osle: Ordinary shelf life estimation (i.e. following the ICH guidance);
  #   RL: Release Limit;
  #   SL: Specification Limit;
  #   wisle: What-if (approach for) shelf life estimation (see ARGPM guidance).

  summary(res3)
  # Expected output of summary(res3)
  # Summary of shelf life estimation following the ARGPM
  #   guidance "Stability testing for prescription medicines"
  #
  # The best model accepted at a significance level of 0.25 has
  #  Different intercepts and Different slopes (acronym: dids).
  #
  # Worst case intercept and batch:
  #   RL Batch Intercept
  # 1 98    b8  101.2594
  #
  # Estimated shelf lives for the dids model (for information, the results of
  #   the model fitted with pooled mean square error (pmse) are also shown:
  #   SL RL    wisle wisle (pmse)     osle osle (pmse)
  # 1 95 98 7.619661     7.483223 15.96453    15.72348
  #
  # Abbreviations:
  #   ARGPM: Australian Regulatory Guidelines for Prescription Medicines;
  #   ICH: International Council for Harmonisation;
  #   osle: Ordinary shelf life estimation (i.e. following the ICH guidance);
  #   pmse: Pooled mean square error;
  #   RL: Release Limit;
  #   SL: Specification Limit;
  #   wisle: What-if (approach for) shelf life estimation (see ARGPM guidance).
}
}
\seealso{
\code{\link{expirest_wisle}}, \code{\link{expirest_osle}},
\code{\link[base]{formatC}}, \code{\link[utils]{methods}}.
}
