% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QC.R
\name{extreme_cases}
\alias{extreme_cases}
\title{Select the subset of extreme cases to evaluation}
\usage{
extreme_cases(pheno, size, omit = NULL, iterations = 500)
}
\arguments{
\item{pheno}{Data.frame with the sample information.}

\item{size}{The number of samples to subset.}

\item{omit}{Name of the columns of the pheno that will be omitted}

\item{iterations}{Numeric value of iterations that will be performed}
}
\value{
A vector with the number of the rows that are selected.
}
\description{
Subset some samples that are mostly different.
}
\examples{
metadata <- expand.grid(height = seq(60, 80, 5), weight = seq(100, 300, 50),
 sex = c("Male","Female"))
sel <- extreme_cases(metadata, 10)
# We can see that it selected both Female and Males and wide range of height
# and weight:
metadata[sel, ]
}
\seealso{
\code{\link{optimum}}
}
