% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/getexif.R
\name{exifr}
\alias{exifr}
\title{Read EXIF data}
\usage{
exifr(filename, recursive = FALSE, quiet = TRUE, exiftoolargs = NULL)
}
\arguments{
\item{filename}{A vector of filenames (like that generated by
\code{list.files(..., full.names=TRUE)})}

\item{recursive}{If directory is specified by \code{filename}, process files recursively.}

\item{quiet}{\code{FALSE} if status updates are desired, \code{TRUE}
otherwise.}

\item{exiftoolargs}{a list of args to be passed to ExifTool (e.g. \code{c("-filename", "-imagesize")})}
}
\value{
A \code{data.frame} of photo EXIF information.
}
\description{
Reads EXIF data into a \code{data.frame} by calling the ExifTool command-line
application, written by Phil Harvey. Depending on number of images and
command-line length requirements, the command may be called multiple times.
}
\details{
From the \href{http://www.sno.phy.queensu.ca/~phil/exiftool/}{ExifTool
website}: ExifTool is a platform-independent Perl library plus a command-line
application for reading, writing and editing meta information in a wide
variety of files. ExifTool supports many different metadata formats including
EXIF, GPS, IPTC, XMP, JFIF, GeoTIFF, ICC Profile, Photoshop IRB, FlashPix,
AFCP and ID3, as well as the maker notes of many digital cameras by Canon,
Casio, FLIR, FujiFilm, GE, HP, JVC/Victor, Kodak, Leaf,
Minolta/Konica-Minolta, Motorola, Nikon, Nintendo, Olympus/Epson,
Panasonic/Leica, Pentax/Asahi, Phase One, Reconyx, Ricoh, Samsung, Sanyo,
Sigma/Foveon and Sony.

For more information, see the \href{http://www.sno.phy.queensu.ca/~phil/exiftool/}{ExifTool
website}
}
\examples{
files <- list.files(path.package("exifr"), recursive=TRUE, pattern="*.jpg", full.names=TRUE)
exifinfo <- exifr(files)
# is equivalent to
exifinfo <- exifr(path.package("exifr"), recursive=TRUE)

exifr(files, exiftoolargs="-filename -imagesize")
}

