% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_data.R
\name{ts_data}
\alias{ts_data}
\alias{dts}
\title{Time Series}
\usage{
ts_data(
  end,
  trend = TRUE,
  trend.coeff = c(1, 1),
  season = TRUE,
  season.coeff = NULL,
  error = TRUE,
  error.coeff = NULL,
  digits = NA
)

dts(
  end,
  trend = TRUE,
  trend.coeff = c(1, 1),
  season = TRUE,
  season.coeff = NULL,
  error = TRUE,
  error.coeff = NULL,
  digits = NA
)
}
\arguments{
\item{end}{integer: length of time series}

\item{trend}{logical: if \code{TRUE} a linear trend otherwise a exponential trend (default: \code{TRUE})}

\item{trend.coeff}{numeric: coefficients for a linear model (default: \code{c(1,1)})}

\item{season}{logical: if \code{TRUE} an additive seasonal adjustment is done otherwise, a multiplicative seasonal adjustment  (default: \code{TRUE})}

\item{season.coeff}{numeric: coefficients for the adjustment (default: \code{NULL}). If \code{NULL} then no seasonal adjustment is made.}

\item{error}{logical: if \code{TRUE} an additive error term is used, otherwise, a multiplicative error term (default: \code{TRUE}).}

\item{error.coeff}{numeric: standard deviation(s) for white noise error (default: \code{NULL}). If \code{NULL} then no error is added.}

\item{digits}{integer: number of digits to round the time series (default: \code{NA}). If \code{NA} then no rounding is done.}
}
\value{
A ts_data object with the following list of elements:
\itemize{
\item \code{t} the time points
\item \code{s} the season for the time points
\item \code{xt} the time series values
}
}
\description{
Creates an univariate time series based on a linear or an exponential trend,
an additive or multiplicative seasonal adjustment and with white noise.
}
\examples{
# Time series from linear trend
ts <- ts_data(12, trend.coeff= c(sample(0:10, 1), sample(1+(1:10)/20, 1)))
ts
# Time series from exponential trend
ts <- ts_data(12, trend.coeff= c(sample(0:10, 1), sample(1+(1:10)/20, 1)), trend=FALSE)
ts   
# Time series from linear trend and additive seasonal adjustment (quartely data)
ts <- ts_data(12, trend.coeff=c(sample(0:10, 1), sample(1+(1:10)/20, 1)),
                  season.coeff=sample((-20:20)/20, 4))
ts   
# Time series from linear trend and additive seasonal adjustment (half-yearly data)
ts <- ts_data(12, trend.coeff=c(sample(0:10, 1), sample(1+(1:10)/20, 1)),
                  season.coeff=sample((-20:20)/20, 2))
ts   
# Time series from linear trend and mutliplicative seasonal adjustment (quartely data)
ts <- ts_data(12, trend.coeff=c(sample(0:10, 1), sample(1+(1:10)/20, 1)),
                  season.coeff=sample((-20:20)/20, 4), season=FALSE)
ts   
}
