% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combinatorics.R
\name{combinatorics}
\alias{combinatorics}
\alias{combs}
\alias{combo}
\alias{fact}
\alias{factquot}
\alias{binom}
\alias{variation}
\alias{combination}
\alias{permutation}
\alias{lfact}
\alias{lfactquot}
\alias{lbinom}
\title{Combinatorics}
\usage{
combinatorics(n, k)

variation(n, k, repl = FALSE)

combination(n, k, repl = FALSE)

permutation(n, k = rep(1, n))

lfact(n)

lfactquot(n, ...)

lbinom(n, k)

combo(n, k, repl = FALSE)

combs(n, k)

fact(n)

factquot(n, ...)

binom(n, k)
}
\arguments{
\item{n}{numeric: total number of elements}

\item{k}{numeric: number of elements to choose}

\item{repl}{logical: with repetition (default: \code{FALSE})}

\item{...}{numeric: further arguments for \code{lfactquot}}
}
\value{
A list.
}
\description{
\itemize{
\item \code{permutation} computes the number of permutations
\item \code{variation} computes the number of variations with and without replication
\item \code{combination} computes the number of combinations with and without replication
\item \code{combinatorics} computes all combinatorics results for \code{k < n} and returns it as list of:
\describe{
\item{\code{permutation.n}}{\eqn{P(n)}}
\item{\code{permutation.k}}{\eqn{P(k)}}
\item{\code{permutation.nk}}{\eqn{P(n; k)}}
\item{\code{variation}}{\eqn{V(n;k)}}
\item{\code{variation.rep}}{\eqn{V^W(n;k)}}
\item{\code{combination}}{\eqn{K(n;k)}}
\item{\code{combination.rep}}{\eqn{K^W(n;k)}}
}
\item \code{lfact} computes the natural logarithm of the factorial of a given number \code{n}
\item \code{lfactquot} calculates the natural logarithm of the quotient of factorials
\item \code{lbinom} computes the natural logarithm of the binomial coefficient, "\code{n} choose \code{k}"
}
}
\examples{
permutation(8)
permutation(8, c(1,3,2,2))
combination(8, 4)
combination(8, 4, TRUE)
variation(8, 4)
variation(8, 4, TRUE)
combinatorics(8, 4)
}
