% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelling.R
\name{print_connection_models_table}
\alias{print_connection_models_table}
\title{Get LaTeX code for the connection bivariate GMM features (mu and sigma)}
\usage{
print_connection_models_table(GMM, label, caption, full_width, filename = NULL)
}
\arguments{
\item{GMM}{Gaussian Mixture Models obtained from function \code{get_connection_models}}

\item{label}{character, e.g. "tab:gmm"}

\item{caption}{character, table caption}

\item{full_width}{logical, if true the "*" will be added next to the "table" tag}

\item{filename}{character, file path to write the latex table to. Is must have ".tex" extension.
If it is NULL, then the character string is returned instead of writing a file.}
}
\value{
character, LaTeX code
}
\description{
Get LaTeX code for the connection bivariate GMM features (mu and sigma)
}
\examples{
# The package evprof provides example objects of connection and energy
# Gaussian Mixture Models obtained from California's open data set
# (see California article in package website) created with functions
# `get_connection models` and `get_energy models`.

# Get the working days connection models
connection_models <- evprof::california_GMM$workdays$connection_models

# Print connection GMM tables
print_connection_models_table(
  GMM = connection_models,
  label = "tab:con-gmm",
  caption = "Connection GMM",
  full_width = TRUE
)


}
