% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{pllik_pwexp}
\alias{pllik_pwexp}
\title{Profile log likelihood for piecewise exponential regression}
\usage{
pllik_pwexp(beta, time, event, J, tcut, x)
}
\arguments{
\item{beta}{The regression coefficients with respect to the covariates.}

\item{time}{The survival time.}

\item{event}{The event indicator.}

\item{J}{The number of time intervals.}

\item{tcut}{A vector that specifies the endpoints of time intervals
for the baseline piecewise exponential survival distribution.
Must start with 0, e.g., c(0, 60) breaks the time axis into 2 event
intervals: [0, 60) and [60, Inf). By default, it is set to 0.}

\item{x}{The covariates matrix (including the intercept).}
}
\value{
The profile log likelihood value for piecewise exponential
regression.
}
\description{
Obtains the profile log likelihood value for piecewise
exponential regression.
}
\keyword{internal}
