% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPrediction.R
\name{getPrediction}
\alias{getPrediction}
\title{Enrollment and event prediction}
\usage{
getPrediction(
  df = NULL,
  to_predict = "enrollment and event",
  target_n = NA,
  target_d = NA,
  enroll_model = "b-spline",
  nknots = 1,
  parameter_enroll_model = NULL,
  lags = 30,
  event_model = "model averaging",
  npieces = 3,
  parameter_event_model = NULL,
  dropout_model = "weibull",
  parameter_dropout_model = NULL,
  fixedFollowup = FALSE,
  followupTime = 365,
  pilevel = 0.9,
  nreps = 500
)
}
\arguments{
\item{df}{The subject-level enrollment and event data,
including \code{randdt}, \code{cutoffdt}, \code{time}, \code{event},
and \code{dropout}. By default, it is set to \code{NULL} for
enrollment and event prediction at the design stage.}

\item{to_predict}{Specifies what to predict: "enrollment only", "event
only", or "enrollment and event". By default, it is set to
"enrollment and event".}

\item{target_n}{The target number of subjects to enroll in the study.}

\item{target_d}{The target number of events to reach in the study.}

\item{enroll_model}{The enrollment model which can be specified as
"Poisson", "time-decay", or "B-spline". By default, it
is set to "B-spline".}

\item{nknots}{The number of inner knots for the B-spline enrollment
model. By default, it is set to 1.}

\item{parameter_enroll_model}{The enrollment model parameters for
design-stage enrollment prediction.}

\item{lags}{The day lags to compute the average enrollment rate to
carry forward for the B-spline enrollment model. By default,
it is set to 30.}

\item{event_model}{The event model which specifies the type of event
model to be used in the analysis and can be set to one of the
following options: "exponential", "Weibull", "log-normal",
"piecewise exponential", or "model averaging", which uses the
\code{exp(-bic)} weighting and combines Weibull and
log-normal models. By default, it is set to "model
averaging".}

\item{npieces}{The number of pieces for the piecewise exponential
event model. By default, it is set to 3.}

\item{parameter_event_model}{The event model parameters for
design-stage event prediction.}

\item{dropout_model}{The dropout model with options including "none",
"exponential", "Weibull", and "log-normal". By default, it is
set to "Weibull".}

\item{parameter_dropout_model}{The dropout model parameters for
design-stage event prediction.}

\item{fixedFollowup}{A Boolean variable indicating whether a fixed
follow-up design is used. By default, it is set to \code{FALSE}
for a variable follow-up design.}

\item{followupTime}{The follow-up time for a fixed
follow-up design, in days. By default, it is set to 365.}

\item{pilevel}{The prediction interval level. By default,
it is set to 0.90.}

\item{nreps}{The number of replications for simulation. By default,
it is set to 500.}
}
\value{
A list that includes the fits of observed data models,
as well as simulated enrollment data for new subjects and
simulated event data for ongoing and new subjects.
}
\description{
Performs enrollment and event prediction by utilizing
observed data and specified enrollment and event models.
}
\details{
For the time-decay model, the mean function is
\code{mu(t) = (mu/delta) (t - (1/delta)(1 - exp(-delta*t)))}
and the rate function is
\code{lambda(t) = (mu/delta) (1 - exp(-delta*t))}.
For the B-spline model, the daily enrollment rate is approximated as
\code{lambda(t) = exp(B(t)*theta)},
where \code{B(t)} represents the B-spline basis functions.

The \code{parameter_enroll_model} variable can be used for
enrollment prediction at the design stage. A piecewise Poisson
can be parameterized through the time
intervals, \code{accrualTime}, and the enrollment rates in
the intervals, \code{accrualIntensity}. These are treated as
fixed for design-stage enrollment prediction.
For the homogeneous Poisson and time-decay models,
\code{parameter_enroll_model} is used to specify the prior
distribution of model parameters, with a very small variance
being used to fix the parameter values. It should be noted
that the B-spline model is not appropriate for use during
the design stage.

For the \code{parameter_event_model}, it should be a list that
includes \code{model} to specify the event process,
\code{ngroups} to indicate the number of treatment groups,
\code{prob} to indicate the randomization probabilities
for each group, \code{theta} and \code{vtheta} to indicate
the parameter values and the covariance matrix, both of which
have \code{ngroups} blocks with the \code{j}-th block specifying
the prior distribution of model parameters for the \code{j}-th
treatment group. For the piecewise exponential event model,
this should also include \code{knots} to indicate the location
of inner knots. It should be noted that the model averaging
option is not appropriate for use during the design stage.

For the \code{parameter_dropout_model}, it should be a list that
includes \code{model} to specify the dropout process,
\code{ngroups} to indicate the number of treatment groups,
\code{prob} to indicate the randomization probabilities
for each group, \code{theta} and \code{vtheta} to indicate
the parameter values and the covariance matrix, both of which
have \code{ngroups} blocks with the \code{j}-th block specifying
the prior distribution of model parameters for the \code{j}-th
treatment group.

For analysis-stage enrollment and event prediction, the
\code{parameter_enroll_model}, \code{parameter_event_model}, and
\code{parameter_dropout_model} are either set to \code{NULL} to
use the observed data only, or specify the prior distribution
of model parameters to be combined with observed data likelihood
for enhanced modeling flexibility.
}
\examples{

# Enrollment and event prediction before enrollment completion

pred <- getPrediction(
  df = observedData, to_predict = "enrollment and event",
  target_n = 400, target_d = 200,
  enroll_model = "b-spline", nknots = 1, lags = 30,
  event_model = "piecewise exponential", npieces = 3,
  dropout_model = "exponential",
  pilevel = 0.90, nreps = 200)

}
