% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_diff.R
\name{plot_diff}
\alias{plot_diff}
\title{Plot the difference from two SpatRaster objects}
\usage{
plot_diff(
  x,
  y,
  col,
  absolute = TRUE,
  relative = TRUE,
  lim_1 = NA,
  lim_2 = NA,
  unit = c(units(x), expression("\%")),
  ...
)
}
\arguments{
\item{x}{SpatVector points}

\item{y}{values to plot}

\item{col}{color}

\item{absolute}{to plot absolute difference}

\item{relative}{to plot relative difference}

\item{lim_1}{range of values for scale}

\item{lim_2}{calculate symmetrical scale}

\item{unit}{annotation for units}

\item{...}{arguments to be passing to plot_raster}
}
\value{
No return value
}
\description{
Custom difference (x - y) plots for SpatRaster object (based on terra package)
}
\examples{

folder <- system.file("extdata",package="eva3dm")
wrf    <- paste0(folder,"/wrfinput_d01")
A      <- wrf_rast(wrf,'XLAT')
terra::units(A) <- 'degrees'
B      <- wrf_rast(wrf,'XLONG')
plot_diff(A,B,int = 2)
}
