% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_eurostat_json.R
\name{get_eurostat_json}
\alias{get_eurostat_json}
\title{Get Data from Eurostat API in JSON}
\usage{
get_eurostat_json(
  id,
  filters = NULL,
  type = "code",
  lang = "EN",
  stringsAsFactors = FALSE,
  ...
)
}
\arguments{
\item{id}{A code name for the dataset of interested. See the table of
contents of eurostat datasets for more details.}

\item{filters}{A named list of filters. Names of list objects are Eurostat
variable codes and values are vectors of observation codes. If \code{NULL}
(default) the whole dataset is returned. See details for more on filters
and limitations per query.}

\item{type}{A type of variables, "\code{code}" (default), "\code{label}" or "\code{both}".
The parameter "\code{both}" will return a data_frame with named vectors,
labels as values and codes as names.}

\item{lang}{A language used for metadata. Default is \code{EN}, other options are
\code{FR} and \code{DE}.}

\item{stringsAsFactors}{if \code{FALSE} (the default) the variables are
returned as characters. If \code{TRUE} the variables are converted to
factors in original Eurostat order.}

\item{...}{
  Arguments passed on to \code{\link[httr:GET]{httr::GET}}
  \describe{
    \item{\code{url}}{the url of the page to retrieve}
    \item{\code{config}}{Additional configuration settings such as http
authentication (\code{\link[httr:authenticate]{authenticate()}}), additional headers
(\code{\link[httr:add_headers]{add_headers()}}), cookies (\code{\link[httr:set_cookies]{set_cookies()}}) etc.
See \code{\link[httr:config]{config()}} for full details and list of helpers.}
    \item{\code{handle}}{The handle to use with this request. If not
supplied, will be retrieved and reused from the \code{\link[httr:handle_pool]{handle_pool()}}
based on the scheme, hostname and port of the url. By default \pkg{httr}
requests to the same scheme/host/port combo. This substantially reduces
connection time, and ensures that cookies are maintained over multiple
requests to the same host. See \code{\link[httr:handle_pool]{handle_pool()}} for more
details.}
  }}
}
\value{
A dataset as an object of \code{data.frame} class.
}
\description{
Retrieve data from Eurostat API in JSON format.
}
\details{
Data to retrieve from
\href{https://ec.europa.eu/eurostat/web/main/data/web-services}{The Eurostat Web Services}
can be specified with filters. Normally, it is
better to use JSON query through \code{\link[=get_eurostat]{get_eurostat()}}, than to use
\code{\link[=get_eurostat_json]{get_eurostat_json()}} directly.

Queries are limited to 50 sub-indicators at a time. A time can be
filtered with fixed "time" filter or with "sinceTimePeriod" and
"lastTimePeriod" filters. A \code{sinceTimePeriod = 2000} returns
observations from 2000 to a last available. A \code{lastTimePeriod = 10}
returns a 10 last observations.

To use a proxy to connect, a \code{\link[httr:use_proxy]{httr::use_proxy()}} can be
passed to \code{\link[httr:GET]{httr::GET()}}. For example
\code{get_eurostat_json(id, filters, config = httr::use_proxy(url, port, username, password))}.
}
\examples{
\dontrun{
# Generally speaking these queries would be done through get_eurostat
tmp <- get_eurostat_json("nama_10_gdp")
yy <- get_eurostat_json("nama_10_gdp", filters = list(
  geo = c("FI", "SE", "EU28"),
  time = c(2015:2023),
  lang = "FR",
  na_item = "B1GQ",
  unit = "CLV_I10"
))

# TIME_PERIOD filter works also with the new JSON API
yy2 <- get_eurostat_json("nama_10_gdp", filters = list(
   geo = c("FI", "SE", "EU28"),
   TIME_PERIOD = c(2015:2023),
   lang = "FR",
   na_item = "B1GQ",
   unit = "CLV_I10"
))
  
# An example from get_eurostat
dd <- get_eurostat("nama_10_gdp",
  filters = list(
  geo = "FI",
  na_item = "B1GQ",
  unit = "CLV_I10"
))
}
}
\references{
See \code{citation("eurostat")}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{# 
# Kindly cite the eurostat R package as follows:
# 
#   (C) Leo Lahti, Janne Huovari, Markus Kainu, Przemyslaw Biecek.
#   Retrieval and analysis of Eurostat open data with the eurostat
#   package. R Journal 9(1):385-392, 2017. doi: 10.32614/RJ-2017-019
#   Package URL: http://ropengov.github.io/eurostat Article URL:
#   https://journal.r-project.org/archive/2017/RJ-2017-019/index.html
# 
# A BibTeX entry for LaTeX users is
# 
#   @Article\{,
#     title = \{Retrieval and Analysis of Eurostat Open Data with the eurostat Package\},
#     author = \{Leo Lahti and Janne Huovari and Markus Kainu and Przemyslaw Biecek\},
#     journal = \{The R Journal\},
#     volume = \{9\},
#     number = \{1\},
#     pages = \{385--392\},
#     year = \{2017\},
#     doi = \{10.32614/RJ-2017-019\},
#     url = \{https://doi.org/10.32614/RJ-2017-019\},
#   \}
}\if{html}{\out{</div>}}
}
\seealso{
\code{\link[httr:GET]{httr::GET()}}

Eurostat Data Browser online help: API Statistics - data query:
\url{https://wikis.ec.europa.eu/display/EUROSTATHELP/API+Statistics+-+data+query}

Eurostat Data Browser online help: migrating from JSON web service to API
Statistics:
\url{https://wikis.ec.europa.eu/display/EUROSTATHELP/API+Statistics+-+migrating+from+JSON+web+service+to+API+Statistics}
}
\author{
Przemyslaw Biecek, Leo Lahti, Janne Huovari Markus Kainu and Pyry Kantanen
}
\keyword{database}
\keyword{utilities}
