% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_eurostat_toc.R
\name{get_eurostat_toc}
\alias{get_eurostat_toc}
\title{Download Table of Contents of Eurostat Data Sets}
\usage{
get_eurostat_toc()
}
\value{
A tibble with eight columns:
\itemize{
\item title: The name of dataset of theme.
\item code: The codename of dataset of theme, will be used by the
\code{\link[=get_eurostat]{get_eurostat()}} and \code{\link[=get_eurostat_raw]{get_eurostat_raw()}} functions.
\item type: Is it a dataset, folder or table.
\item last.update.of.data, last.table.structure.change,
data.start, data.end: Dates.
}
}
\description{
Download table of contents (TOC) of eurostat datasets.
}
\details{
The TOC is downloaded from \url{https://ec.europa.eu/eurostat/estat-navtree-portlet-prod/BulkDownloadListing?sort=1&file=table_of_contents_en.txt}. The values in column 'code' should be used to download a selected dataset.
}
\examples{
\dontshow{if (check_access_to_data()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
tmp <- get_eurostat_toc()
head(tmp)
}
\dontshow{\}) # examplesIf}
}
\references{
See \code{citation("eurostat")}:\preformatted{# 
# Kindly cite the eurostat R package as follows:
# 
#   (C) Leo Lahti, Janne Huovari, Markus Kainu, Przemyslaw Biecek.
#   Retrieval and analysis of Eurostat open data with the eurostat
#   package. R Journal 9(1):385-392, 2017. doi: 10.32614/RJ-2017-019
#   Package URL: http://ropengov.github.io/eurostat Article URL:
#   https://journal.r-project.org/archive/2017/RJ-2017-019/index.html
# 
# A BibTeX entry for LaTeX users is
# 
#   @Article\{,
#     title = \{Retrieval and Analysis of Eurostat Open Data with the eurostat Package\},
#     author = \{Leo Lahti and Janne Huovari and Markus Kainu and Przemyslaw Biecek\},
#     journal = \{The R Journal\},
#     volume = \{9\},
#     number = \{1\},
#     pages = \{385--392\},
#     year = \{2017\},
#     doi = \{10.32614/RJ-2017-019\},
#     url = \{https://doi.org/10.32614/RJ-2017-019\},
#   \}
}
}
\seealso{
\code{\link[=get_eurostat]{get_eurostat()}}, \code{\link[=search_eurostat]{search_eurostat()}}.
}
\author{
Przemyslaw Biecek and Leo Lahti \href{mailto:ropengov-forum@googlegroups.com}{ropengov-forum@googlegroups.com}
}
\keyword{database}
\keyword{utilities}
