% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rt_indices_from_bin.R
\name{rt.indices.from.bin}
\alias{rt.indices.from.bin}
\title{Dosimetry, volume, conformity, homogeneity indices from binary selection}
\usage{
rt.indices.from.bin(
  vol,
  target.bin.list = NULL,
  healthy.bin.list = NULL,
  T.MAT = NULL,
  presc.dose = NA,
  healthy.tol.dose = NA,
  healthy.weight = 1,
  dosimetry = c("D.min", "D.max", "D.mean", "STD"),
  volume.indices = c("V.tot", "area", "V.prescdose"),
  conformity.indices = c("PITV", "CI.lomax2003", "CN", "NCI", "DSC", "CI.distance",
    "CI.abs_distance", "CDI", "CS3", "ULF", "OHTF", "gCI", "COIN", "G_COSI", "COSI"),
  homogeneity.indices = c("HI.RTOG.max_ref", "HI.RTOG.5_95", "HI.ICRU.max_min",
    "HI.ICRU.2.98_ref", "HI.ICRU.2.98_50", "HI.ICRU.5.95_ref", "HI.mayo2010",
    "HI.heufelder"),
  gradient.indices = c("GI.ratio.50"),
  D.xpc = NULL,
  D.xcc = NULL,
  V.xpc = NULL,
  V.xGy = NULL,
  verbose = TRUE
)
}
\arguments{
\item{vol}{"volume" class object, of "rtdose" modality.}

\item{target.bin.list}{list of "volume" class objects, of "binary"
modality. The \code{$object.alias} field of each \code{target.bin.list} object
represents the name of the selected region of interest of the target volume.}

\item{healthy.bin.list}{list of "volume" class objects, of "binary"
modality. The \code{$object.alias} field of each \code{healthy.bin.list} object
represents the name of the selected region of interest of the healthy tissues.}

\item{T.MAT}{"t.mat" class object, created by \link[espadon]{load.patient.from.Rdcm}
or \link[espadon]{load.T.MAT}. If \code{T.MAT = NULL}, all \code{$ref.pseudo}
of \code{bin.list} elements must be equal to \code{vol$ref.pseudo}.}

\item{presc.dose}{vector of prescription doses that serve as reference doses
for the target RoI.}

\item{healthy.tol.dose}{vector of tolerance dose of each healthy RoI.}

\item{healthy.weight}{Vector of weight, indicating the importance of the healthy
RoI.}

\item{dosimetry}{Vector indicating the requested dose indicators from among
'D.min', 'D.max', 'D.mean' and 'STD.' If \code{D.xpc} is different from
\code{NULL}, it will be added.}

\item{volume.indices}{Vector indicating the requested volume indices from among
'V.tot',  'V.prescdose' (i.e. volume over \code{presc.dose}) and 'area'. If
\code{V.xGy} is different from \code{NULL}, it will be added.}

\item{conformity.indices}{Vector. Requested conformity indices from among 'PITV',
'PDS', 'CI.lomax2003', 'CN', 'NCI', 'DSC', 'CI.distance', 'CI.abs_distance',
'CDI', 'CS3', 'ULF', 'OHTF', 'gCI', 'COIN', 'COSI' and 'G_COSI'.}

\item{homogeneity.indices}{Vector. Requested homogeneity indices from among
'HI.RTOG.max_ref', 'HI.RTOG.5_95', 'HI.ICRU.max_min', 'HI.ICRU.2.98_ref',
'HI.ICRU.2.98_50', 'HI.ICRU.5.95_ref', 'HI.mayo2010' and 'HI.heufelder.'}

\item{gradient.indices}{Vector. Requested gradient indices from among
'GI.ratio.50', 'mGI'.}

\item{D.xpc}{Vector of the percentage of the volume, for which the dose coverage
is requested.}

\item{D.xcc}{Vector of the volume in \mjeqn{cm^3}{ascii}, for which the dose
coverage is requested.}

\item{V.xpc}{Vector of the percentage of the reference dose, received by the volume to be
calculated.}

\item{V.xGy}{Vector of the minimum dose in Gy, received by the volume to be
calculated.}

\item{verbose}{Boolean. if \code{TRUE} (default) a progress bar is displayed.}
}
\value{
Return  a list of  indices dataframe. For details, see
\link[espadon]{rt.indices.from.roi}.
}
\description{
The \code{rt.indices.from.bin} function calculates, from a
"volume" class object of modality "rtdose", all the standard
indicators of radiotherapy, as long as their options are transmitted, for the
target and healthy "volume" object of modality "binary".
}
\examples{
# loading of toy-patient objects (decrease dxyz and increase beam.nb for better
# result)
step <- 5
patient <- toy.load.patient (modality = c("rtdose", "rtstruct"), roi.name = "eye",
                             dxyz = rep (step, 3), beam.nb = 3)
D <- patient$rtdose[[1]]
struct <- patient$rtstruct[[1]]
T.MAT <- patient$T.MAT

# creation of the list of target binary volumes
taget.roi.idx <- select.names (struct$roi.info$roi.pseudo, roi.sname = "ptv")
healthy.roi.idx <- select.names (struct$roi.info$roi.pseudo, roi.sname = "eye")
target.bin.list <- lapply (taget.roi.idx , function (idx) {
  vr <- nesting.roi (D, struct, roi.idx = idx, xyz.margin = c (5, 5, 5),
                     T.MAT = T.MAT, alias = struct$roi.info$name[idx])
  b <- bin.from.roi(vr, struct, roi.idx = idx, T.MAT = T.MAT,
                    alias = struct$roi.info$name[idx])
  })
names (target.bin.list) <- struct$roi.info$name[taget.roi.idx]

healthy.bin.list <- lapply (healthy.roi.idx , function (idx) {
  vr <- nesting.roi (D, struct, roi.idx = idx, xyz.margin = c (5, 5, 5),
                     T.MAT = T.MAT, alias = struct$roi.info$name[idx])
  b <- bin.from.roi(vr, struct, roi.idx = idx, T.MAT = T.MAT,
                    alias = struct$roi.info$name[idx])
})
names (healthy.bin.list) <- struct$roi.info$name[healthy.roi.idx]

indices <- rt.indices.from.bin (D, target.bin.list, healthy.bin.list,
                                presc.dose = 50,
                                conformity.indices = c("PITV", "PDS", "CI.lomax2003", 
                                                       "CN", "NCI", "DSC","COIN"),
                                verbose = FALSE)
indices
}
\seealso{
\link[espadon]{rt.indices.from.roi}.
}
