% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_organisecentaurfiles.R
\name{aux_organisecentaurfiles}
\alias{aux_organisecentaurfiles}
\title{Reorganise seismic files recorded by Nanometrics Centaur loggers}
\usage{
aux_organisecentaurfiles(
  stationfile,
  input_dir,
  output_dir,
  format = "sac",
  channel_name = "bh",
  cpu,
  gipptools,
  file_key = "miniseed",
  network
)
}
\arguments{
\item{stationfile}{\code{Character} value, file name of the station info 
file, with extension. See \code{aux_stationinfofile}.}

\item{input_dir}{\code{Character} value, path to directory where all 
files to be processed as stored. Each set of files from one logger must be 
stored in a separate sub-directory named after the logger ID (which in 
turn must be the four digit number of the logger).}

\item{output_dir}{\code{Character} value, path to directory where output 
data is written to.}

\item{format}{\code{Character} value, output file format. One out of 
\code{"mseed"} and \code{"sac"}. Default is \code{"sac"}.}

\item{channel_name}{\code{Character} value, output file extension. One out 
of \code{"bh"} and \code{"p"}. Default is \code{"bh"}.}

\item{cpu}{\code{Numeric} value, fraction of CPUs to use for parallel 
processing. If omitted, one CPU is used.}

\item{gipptools}{\code{Character} value, path to gipptools or cubetools 
directory.}

\item{file_key}{\code{Character} value, file name extension of the files
to process. Only files with this extension will be processed. Default is 
\code{"miniseed"}.}

\item{network}{\code{Character} value, optional seismic network code.}
}
\value{
A set of hourly seismic files written to disk.
}
\description{
This function optionally converts mseed files to sac files and 
organises these in a coherent directory structure, by year, Julian day, 
(station, hour and channel). It depends on the cubetools or gipptools  
software package (see details). The function is at an experimental stage  
and only used for data processing at the GFZ Geomorphology section, 
currently.
}
\details{
The function assumes that the Nanometrics Centaur data logger directory 
contains only hourly mseed files. These hourly files are organised in a 
coherent directory structure which is organised by year and Julian day. 
In each Julian day directory the hourly files are placed and named according 
to the following scheme: 
STATIONID.YEAR.JULIANDAY.HOUR.MINUTE.SECOND.CHANNEL.\cr
The function requires that the software cubetools 
(\code{http://www.omnirecs.de/documents.html}) or gipptools 
(\code{http://www.gfz-potsdam.de/en/section/geophysical-deep-sounding/infrastructure/geophysical-instrument-pool-potsdam-gipp/software/gipptools/}) 
are installed. \cr Specifying an input directory 
(\code{input_dir}) is mandatory. This input directory must only contain the 
subdirectories with mseed data for each Centaur logger. The subdirectory 
must be named after the four digit Centaur ID and contain only mseed files,
regardless if further subdirectories are used (e.g., for calendar days). 

In the case a six-channel Centaur is used to record signals from two
sensors, in the station info file (cf. \code{aux_stationinfofile()})
the logger ID field must contain the four digit logger ID and the 
channel qualifiers, e.g., "AH" (first three channels) or "BH" (last three channels), 
separated by an underscore.
}
\examples{

\dontrun{

## basic example with minimum effort
aux_organisecentaurfiles(stationfile = "output/stationinfo.txt", 
                         input_dir = "input", 
                         gipptools = "software/gipptools-2015.225/")

}
                        
}
\author{
Michael Dietze
}
\keyword{eseis}
