% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{data_mccabemichael_brain}
\alias{data_mccabemichael_brain}
\title{McCabeMichael brain - Ch9 - from Michael et al. (2013)}
\format{
\subsection{\code{data_mccabemichael_brain}}{

A data frame with 10 rows and 9 columns:
\describe{
\item{Study name}{factor}
\item{M No Brain}{numeric}
\item{s No Brain}{numeric}
\item{n No Brain}{numeric}
\item{M Brain}{numeric}
\item{s Brain}{numeric}
\item{n Brain}{numeric}
\item{SimpleCritique}{factor}
\item{Research group}{factor}
}
}
}
\source{
\doi{10.3758/s13423-013-0391-6}
}
\usage{
data_mccabemichael_brain
}
\description{
You've probably seen cross sections of the brain with
brightly colored areas indicating which brain regions are most active during
a particular type of cognition or emotion. Search online for fMRI (functional
magnetic resonance imaging) brain scans to see such pictures and learn how
they are made. They can be fascinating-are we at last able to see how
thinking works? In 2008, McCabe and Castel published studies that
investigated how adding a brain picture might alter judgments of the
credibility of a scientific article. For one group of participants, an
article was accompanied by a brain image that was irrelevant to the article.
For a second, independent group, there was no image. Participants read the
article, then gave a rating of the statement 'The scientific reasoning in the
article made sense'. The response options were 1 (strongly disagree), 2
(disagree), 3 (agree), and 4 (strongly agree). The researchers reported that
mean ratings were higher with a brain picture than without, but that the
difference was small. It seemed that an irrelevant brain picture may have
some, but only a small influence. The authors drew appropriately cautious
conclusions, but the result quickly attracted attention and there were many
media reports that greatly overstated it. At least according to the popular
media, it seemed that adding a brain picture made any story convincing.
Search on 'McCabe seeing is believing', or similar, to find media reports and
blog posts. Some warned readers to watch out for brain pictures, which, they
said, can trick you into believing things that aren't true. The result
intrigued some New Zealander colleagues of mine who discovered that, despite
its wide recognition, the finding hadn't been replicated. They ran
replication studies using the materials used by the original researchers, and
found generally small ESs. I joined the team at the data analysis stage and
the research was published (Michael et al., 2013). I'll discuss here a
meta-analysis of two of the original studies and eight replications by our
team. The studies were sufficiently similar for meta-analysis, especially
considering that all the Michael studies were designed to have many features
that matched the original studies.  This data set does \emph{not} include
two additional critique studies run by the Michael team.  See also
data_mccabemichael_brain2
}
\keyword{datasets}
