% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CI_smd_one.R
\name{CI_smd_one}
\alias{CI_smd_one}
\title{Estimate standardized mean difference (Cohen's d1) for a single group}
\usage{
CI_smd_one(mean, sd, n, reference_mean, conf_level = 0.95, correct_bias = TRUE)
}
\arguments{
\item{mean}{Mean for a single group for the outcome measure}

\item{sd}{Standard deviation, > 0}

\item{n}{Sample size, an integer > 2}

\item{reference_mean}{defaults to 0}

\item{conf_level}{The confidence level for the confidence interval, in
decimal form.  Defaults to 0.95.}

\item{correct_bias}{Defaults to TRUE}
}
\value{
Returns a list with these named elements:
\itemize{
\item effect_size - the point estimate from the sample
\item lower - lower bound of the CI
\item upper - upper bound of the CI
\item numerator - the numerator for Cohen's d_biased;
the mean difference in the contrast
\item denominator - the denominator for Cohen's d_biased;
if equal variance is assumed this is sd_pooled, otherwise sd_avg
\item df - the degrees of freedom used for correction and CI calculation
\item se - the standard error of the estimate; \strong{warning} not totally
sure about this yet
\item moe - margin of error; 1/2 length of the CI
\item d_biased - Cohen's d without correction applied
\item properties - a list of properties for the result
}

Properties
\itemize{
\item effect_size_name - if equal variance assumed d_s, otherwise d_avg
\item effect_size_name_html - html representation of d_name
\item denominator_name - if equal variance assumed sd_pooled otherwise sd_avg
\item denominator_name_html - html representation of denominator name
\item bias_corrected - TRUE/FALSE if bias correction was applied
\item message - a message explaining denominator and correction status
\item message_html - html representation of message
}
}
\description{
\code{CI_smd_one} STILL NEEDS WORK TO VERIFY APPROACH FOR SE and MoE
}
\examples{
# example code
res <- esci::CI_smd_one(24.5, 3.65, 40, 20)

}
