% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{data_clean_moral}
\alias{data_clean_moral}
\title{Clean moral - Ch07 - from Schnall et al. (2008), Study 1, and Johnson et al. (2014)}
\format{
\subsection{\code{data_clean_moral}}{

A data frame with 208 rows and 4 columns:
\describe{
\item{Schnall Condition}{factor}
\item{Schnall Moral judgment}{numeric}
\item{Johnson Condition}{factor}
\item{Johnson Moral judgment}{numeric}
}
}
}
\source{
\url{https://econtent.hogrefe.com/doi/full/10.1027/1864-9335/a000186}
}
\usage{
data_clean_moral
}
\description{
Some researchers claim that moral judgments are based not only on rational
considerations but also on one's current emotional state. To what extent can
recent emotional experiences influence moral judgments? Schnall et al. (2008)
examined this question by manipulating feelings of cleanliness and purity and
then observing the extent that this changes how harshly participants judge
the morality of others. Inscho Study 1, Schnall et al. asked participants to
complete a word scramble task with either neutral words (neutral prime) or
words related to cleanliness (cleanliness prime). All students then completed
a set of moral judgments about controversial scenarios: Moral judgment is the
average of six items, each rated on a scale from 0 to 9, with high meaning
harsh. The data from this study are in the Clean moral file, which also
contains data from a replication by Johnson et al. (2014)
}
\keyword{datasets}
