% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formula.utils.R
\name{enformulate.curved}
\alias{enformulate.curved}
\alias{enformulate.curved.ergm}
\alias{enformulate.curved.formula}
\title{Convert a curved ERGM into a form suitable as initial values for the same
ergm.}
\usage{
enformulate.curved(object, ...)

\method{enformulate.curved}{ergm}(object, ...)

\method{enformulate.curved}{formula}(object, theta, response = NULL, ...)
}
\arguments{
\item{object}{An \code{\link{ergm}} object or an ERGM formula. The curved
terms of the given formula (or the formula used in the fit) must have all of
their arguments passed by name.}

\item{\dots}{Unused at this time.}

\item{theta}{Curved model parameter configuration.}

\item{response}{Name of the edge attribute whose value is to be
modeled in the valued ERGM framework. Defaults to \code{NULL} for
simple presence or absence, modeled via a binary ERGM.}
}
\value{
A list with the following components: \item{formula}{The formula
with curved parameter estimates incorporated.} \item{theta}{The coefficient
vector with curved parameter estimates removed.}
}
\description{
The generic \code{enformulate.curved} converts an \code{\link{ergm}} object
or formula of a model with curved terms to the variant in which the curved
parameters embedded into the formula and are removed from the parameter
vector. This is the form required by \code{\link{ergm}} calls.
}
\details{
Because of a current kludge in \code{\link{ergm}}, output from one run
cannot be directly passed as initial values (\code{control.ergm(init=)}) for
the next run if any of the terms are curved. One workaround is to embed the
curved parameters into the formula (while keeping \code{fixed=FALSE}) and
remove them from \code{control.ergm(init=)}.

This function automates this process for curved ERGM terms included with the
\code{\link[=ergm-package]{ergm}} package. It does not work with curved
terms not included in ergm.
}
\examples{

\donttest{
\dontshow{
options(ergm.eval.loglik=FALSE)
}
data(sampson)
gest<-ergm(samplike~edges+gwesp(decay=.5, fixed=FALSE), 
    control=control.ergm(MCMC.burnin=1024, MCMC.interval=8, MCMLE.maxit=1))
# Error:
gest2<-try(ergm(gest$formula,
                control=control.ergm(init=coef(gest), MCMC.burnin=1024,
                                     MCMC.interval=8, MCMLE.maxit=1)))
print(gest2)

# Works:
tmp<-enformulate.curved(gest)
tmp
gest2<-try(ergm(tmp$formula,
                control=control.ergm(init=tmp$theta, MCMC.burnin=1024,
                                     MCMC.interval=8, MCMLE.maxit=1)))
summary(gest2)
}

}
\seealso{
\code{\link{ergm}}, \code{\link{simulate.ergm}}
}
\keyword{model}
