% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network.update.R
\name{update.network}
\alias{update.network}
\title{Update the edges in a network based on a matrix}
\usage{
\method{update}{network}(
  object,
  new,
  matrix.type = NULL,
  attrname = NULL,
  ...,
  ignore.nattr = c("bipartite", "directed", "hyper", "loops", "mnext", "multiple", "n"),
  ignore.vattr = c()
)
}
\arguments{
\item{object}{a \code{\link{network}} object.}

\item{new}{Either an adjacency matrix (a matrix of values
indicating the presence and/or the value of a tie from i to j) or
an edge list (a two-column matrix listing origin and destination
node numbers for each edge, with an optional third column for the
value of the edge).}

\item{matrix.type}{One of \code{"adjacency"} or \code{"edgelist"} telling
which type of matrix \code{new} is.  Default is to use the
\code{\link[network]{which.matrix.type}} function.}

\item{attrname}{For a network with edge weights gives the name of
the edge attribute whose names to set.}

\item{\dots}{Additional arguments; currently unused.}

\item{ignore.nattr}{Character vector of the names of network-level
attributes to ignore when updating network objects (defaults to
standard network properties).}

\item{ignore.vattr}{Character vector of the names of vertex-level
attributes to ignore when updating network objects.}
}
\value{
A new \code{\link{network}} object with the edges specified by
\code{new} and network and vertex attributes copied from
the input network \code{object}. Input network is not modified.
}
\description{
Replaces the edges in a \code{\link{network}} object with the edges corresponding
to the sociomatrix or edge list specified by \code{new}.
}
\examples{

#
data(florentine)
#
# test the network.update function
#
# Create a Bernoulli network
rand.net <- network(network.size(flomarriage))
# store the sociomatrix 
rand.mat <- rand.net[,]
# Update the network
update(flomarriage, rand.mat, matrix.type="adjacency")
# Try this with an edgelist
rand.mat <- as.matrix.network.edgelist(flomarriage)[1:5,]
update(flomarriage, rand.mat, matrix.type="edgelist")

}
\seealso{
\code{\link[=ergm]{ergm()}}, \code{\link{network}}
}
\keyword{models}
