% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.dyad.independent.R
\name{is.dyad.independent}
\alias{is.dyad.independent}
\alias{is.dyad.independent.NULL}
\alias{is.dyad.independent.formula}
\alias{is.dyad.independent.ergm_conlist}
\alias{is.dyad.independent.ergm}
\title{Testing for dyad-independence}
\usage{
is.dyad.independent(object, ...)

\method{is.dyad.independent}{`NULL`}(object, ...)

\method{is.dyad.independent}{formula}(object, response = NULL, basis = NULL, ...)

\method{is.dyad.independent}{ergm_conlist}(object, object.obs = NULL, ...)

\method{is.dyad.independent}{ergm}(object, ...)
}
\arguments{
\item{object}{The object to be tested for dyadic independence.}

\item{\dots}{Unused at this time.}

\item{response}{Name of the edge attribute whose value is to be
modeled in the valued ERGM framework. Defaults to \code{NULL} for
simple presence or absence, modeled via a binary ERGM.}

\item{basis}{See \code{\link{ergm}}.}

\item{object.obs}{For the \code{\link{ergm_conlist}} method, the observed data constraint.}
}
\value{
\code{TRUE} if the model implied by the object is
dyad-independent; \code{FALSE} otherwise.
}
\description{
These functions test whether an ERGM fit, a formula, or some other
object represents a dyad-independent model.

The method for \code{NULL} always returns \code{TRUE} by
convention.
}
\details{
Dyad independence is determined by checking if all of the
constituent parts of the object (formula, ergm terms, constraints,
etc.) are flagged as dyad-independent.
}
\keyword{model}
