% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gofN.R
\name{plot.gofN}
\alias{plot.gofN}
\alias{autoplot.gofN}
\title{Plotting methods for \code{\link{gofN}}, making residual and scale-location plots.}
\usage{
\method{plot}{gofN}(
  x,
  against = NULL,
  which = 1:2,
  col = 1,
  pch = 1,
  cex = 1,
  bg = 0,
  ...,
  ask = length(which) > 1 && dev.interactive(TRUE),
  id.n = 3,
  id.label = NULL,
  main = "{type} for {sQuote(name)}",
  xlab = NULL,
  ylim = NULL,
  cex.id = 0.75
)

\method{autoplot}{gofN}(
  x,
  against = .fitted,
  which = 1:2,
  mappings = list(),
  geom_args = list(),
  id.n = 3,
  id.label = NULL
)
}
\arguments{
\item{x}{a \code{\link{gofN}} object.}

\item{against}{what the residuals should be plotted against. Note that different methods use different formats: see Details. Categorical (\code{\link{factor}} and \code{\link{ordered}}) values are visualised using boxplots, with \code{\link{ordered}} values also adding a smoothing line like the quantitative. Defaults to the fitted values.}

\item{which}{which to plot (\code{1} for residuals plot, \code{2} for \eqn{\sqrt{|R_i|}}{sqrt(|R_i|)} scale plot, and \code{3} for normal quantile-quantile plot).}

\item{col, pch, cex, bg}{vector of values (wrapped in \code{\link[=I]{I()}}), network attribute, or a formula whose RHS gives an expression in terms of network attributes to plot against.}

\item{...}{additional arguments to \code{\link[=plot]{plot()}}, \code{\link[=qqnorm]{qqnorm()}}, and \code{\link[=qqline]{qqline()}}, and others.}

\item{ask}{whether the user should be prompted between the plots.}

\item{id.n}{maximum number of extreme points to label explicitly.}

\item{id.label}{specification for how extreme points are to be labeled, defaulting to network's index in the combined network.}

\item{main}{a template for the plots' titles; these use \code{\link[=glue]{glue()}}'s templating, with \code{{type}} replaced with the type of plot and \code{{name}} replaced with the statistic.}

\item{xlab}{horizontal axis label; defaults to a character representation of \code{against}.}

\item{ylim}{vertical range for the plots, interpreted as in \code{\link[graphics:plot.default]{graphics::plot()}}; can be specified as a list with 3 elements, giving the range for the corresponding plot according to the plot numbers for the \verb{which=} argument, and can be used to ensure that, e.g., diagnostic plots for different models are on the same scale.}

\item{cex.id}{scaling factor for characters used to label extreme points; see \code{\link[=plot.lm]{plot.lm()}}.}

\item{mappings}{a named list of lists of mappings constructed by \code{\link[ggplot2:aes]{ggplot2::aes()}} overriding the defaults. See Details below.}

\item{geom_args}{a named list of lists of arguments overriding the defaults for the individual geoms. See Details below.}
}
\value{
\code{autoplot.gofN()} returns a list of \code{ggplot} objects that
if printed render to diagnostic plots. If there is only one, the
object itself is returned.
}
\description{
The \code{\link[=plot]{plot()}} method uses \R graphics.

The \code{\link[ggplot2:autoplot]{ggplot2::autoplot()}} method uses \CRANpkg{ggplot2} and \CRANpkg{ggrepel}.
}
\details{
For the \code{plot()} method, \code{against} and \code{id.label} can be vectors of values (enclosed in \code{\link[=I]{I()}} to be used as is), a character string identifying a network attribute, or a formula whose RHS gives an expression in terms of network attributes to plot against. The \code{against} formula may also contain a \code{.fitted} variable which will be substituted with the fitted values.

For \code{autoplot.gofN()}, \code{against} and \code{id.label} are interpreted as
expressions in terms of network attributes and values generated by
\code{\link[=augment.gofN]{augment.gofN()}}, included \code{.fitted} for the fitted values.
}
\section{Customising \code{autoplot.gofN()}}{


\code{autoplot.gofN()} constructs the plots out of \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}},
\code{\link[ggplot2:geom_point]{ggplot2::geom_point()}} (for numeric \code{against}), \code{\link[ggplot2:geom_boxplot]{ggplot2::geom_boxplot()}} for
categorical or ordinal \code{against}), and \code{\link[ggplot2:geom_smooth]{ggplot2::geom_smooth()}} (for numeric
or ordinal \code{against}), and \code{\link[ggrepel:geom_text_repel]{ggrepel::geom_text_repel()}}. Mappings and
arguments passed through \code{mappings} and \code{geom_args} override the
respective defaults. They may have elements \code{default} (for
\code{ggplot()}), \code{point} (for \code{geom_point()} and \code{geom_boxplot()}),
\code{smooth} (for \code{geom_smooth}), and \code{text} (for \code{geom_text_repel()}).
}

\seealso{
\code{\link[=gofN]{gofN()}} for examples, \code{\link[=plot.lm]{plot.lm()}}, \code{\link[graphics:plot.default]{graphics::plot()}} for regression diagnostic plots and their parameters.
}
