% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netcdf.R
\name{summary_database}
\alias{summary_database}
\title{Summary CMIP6 model output file status}
\usage{
summary_database(
  dir,
  by = c("activity", "experiment", "variant", "frequency", "variable", "source",
    "resolution"),
  mult = c("skip", "latest"),
  append = FALSE,
  miss = c("keep", "overwrite"),
  recursive = FALSE,
  update = FALSE,
  warning = TRUE
)
}
\arguments{
\item{dir}{A single string indicating the directory where CMIP6 model output
NetCDF files are stored.}

\item{by}{The grouping column to summary the database status. Should be a
subset of:
\itemize{
\item \code{"experiment"}: root experiment identifiers
\item \code{"source"}: model identifiers
\item \code{"variable"}: variable identifiers
\item \code{"activity"}: activity identifiers
\item \code{"frequency"}: sampling frequency
\item \code{"variant"}: variant label
\item \code{"resolution"}: approximate horizontal resolution
}}

\item{mult}{Actions when multiple files match a same case in the CMIP6
index. If \code{"latest"}, the file with latest modification time
will be used. If \code{"skip"}, all matched files will be skip and this
case will be kept as unmatched. Default: \code{"skip"}.}

\item{append}{If \code{TRUE}, status of CMIP6 files will only be updated if they
are not found in previous summary. This is useful if CMIP6 files are
stored in different directories. Default: \code{FALSE}.}

\item{miss}{Actions when matched files in the previous summary do not exist
when running current summary. Only applicable when \code{append} is set to
\code{TRUE}. If \code{"keep"}, the metadata for the missing output files will
be kept. If \code{"overwrite"}, existing metadata of those output will be
first removed from the output file index and overwritten based on the
newly matched files if possible. Default: \code{"keep"}.}

\item{recursive}{If \code{TRUE}, scan recursively into directories. Default:
\code{FALSE}.}

\item{update}{If \code{TRUE}, the output file index will be updated based
on the matched NetCDF files in specified directory. If \code{FALSE}, only
current loaded index will be updated, but the actual index
database file saved in \code{\link[=get_data_dir]{get_data_dir()}} will remain unchanged.
Default: \code{FALSE}.}

\item{warning}{If \code{TRUE}, warning messages will show when target files are
missing or multiple files match a same case. Default: \code{TRUE}.}
}
\value{
A \code{\link[data.table:data.table]{data.table::data.table()}} containing corresponding grouping
columns plus:\tabular{lll}{
   Column \tab Type \tab Description \cr
   \code{datetime_start} \tab POSIXct \tab Start date and time of simulation \cr
   \code{datetime_end} \tab POSIXct \tab End date and time of simulation \cr
   \code{file_num} \tab Integer \tab Total number of file per group \cr
   \code{file_size} \tab Units (Mbytes) \tab Approximate total size of file \cr
   \code{dl_num} \tab Integer \tab Total number of file downloaded \cr
   \code{dl_percent} \tab Units (\%) \tab Total percentage of file downloaded \cr
   \code{dl_size} \tab Units (Mbytes) \tab Total size of file downloaded \cr
}


Also 2 extra \code{\link[data.table:data.table]{data.table::data.table()}} are attached as \strong{attributes}:
\itemize{
\item \code{not_found}: A \code{\link[data.table:data.table]{data.table::data.table()}} that contains metadata for those
CMIP6 outputs that are listed in current CMIP6 output file index but the
existing file paths are not valid now and cannot be found in current
database.
\item \code{not_matched}: A \code{\link[data.table:data.table]{data.table::data.table()}} that contains metadata for
those CMIP6 output files that are found in current database but not listed
in current CMIP6 output file index.
}

For the meaning of grouping columns, see \code{\link[=init_cmip6_index]{init_cmip6_index()}}.
}
\description{
\code{summary_database()} scans the directory specified and returns a
\code{\link[=data.table]{data.table()}} containing summary information about all the CMIP6
files available against the output file index loaded using
\code{\link[=load_cmip6_index]{load_cmip6_index()}}.
}
\details{
The database here can be any directory that stores the NetCDF files for CMIP6
GCMs. It can be also be the same as \code{get_data_dir()} where epwshiftr stores
the output file index, if you want to save the output file index and output
files in the same place.

\code{summary_database()} uses the \code{tracking_id}, \code{datetime_start} and
\code{datetime_end} global attributes of each NetCDF file to match against the
output file index. So the names of NetCDF files do not necessarily follow the
CMIP6 file name encoding.

\code{summary_database()} will append 5 columns in the CMIP6 output file index:
\itemize{
\item \code{file_path}: the full path of matched NetCDF file for every case.
}

\code{summary_database()} uses \link[future.apply:future_lapply]{future.apply}
underneath to speed up the data processing if applicable. You can use your
preferable future backend to speed up data extraction in parallel. By default,
\code{summary_database()} uses \code{future::sequential} backend, which runs things in
sequential.
}
\examples{
\dontrun{
summary_database()

summary_database(by = "experiment")
}

}
