##' @title Identify single-species cells
##'
##' @description Given a epmGrid object, return the grid cell indices
##' 	of those cells that have just one species. 
##'
##' @param x object of class \code{epmGrid}
##'
##' @details This function can be useful when further analyzing epmGrid
##' 	objects generated by \code{\link{gridMetrics}}, as it might
##' 	make sense to exclude these single-species cells in further analyses. 
##'
##' 
##' @return numeric vector of grid cell indices. 
##'
##' @author Pascal Title
##' 
##' @examples
##' singleSpCellIndex(tamiasEPM)
##' 
##' @export


# identify single-species cells

singleSpCellIndex <- function(x) {

	if (!inherits(x, 'epmGrid')) {
		stop('Object must be of class epmGrid')
	}
	
	singleSp <- which(lengths(x[['speciesList']]) == 1 & sapply(x[['speciesList']], anyNA) == FALSE)
	singleSpCells <- which(x[['cellCommInd']] %in% singleSp)
	return(singleSpCells)
}