% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reduceToCommonTaxa.R
\name{reduceToCommonTaxa}
\alias{reduceToCommonTaxa}
\title{Subset epmGrid to shared taxa}
\usage{
reduceToCommonTaxa(x)
}
\arguments{
\item{x}{object of class \code{epmGrid}}
}
\value{
new \code{epmGrid} object.
}
\description{
An epmGrid object may contain more taxa with morphological
	data than taxa with phylogenetic information, or vice versa. This 
	function subsets all epmGrid components to the set of taxa shared 
	across geographic, phenotypic and phylogenetic datasets. This might
	desirable to ensure that all diversity metrics are based on the same 
	set of taxa.
}
\examples{
tamiasEPM
# randomly drop a few species for demonstration
tamiasEPM <- addPhylo(tamiasEPM, ape::drop.tip(tamiasTree, sample(tamiasTree$tip.label, 5)))
tamiasEPM <- addTraits(tamiasEPM, tamiasTraits[-(3:5),])

new <- reduceToCommonTaxa(tamiasEPM)

tamiasEPM
new


}
\author{
Pascal Title
}
