% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateOccurrenceMatrix.R
\name{generateOccurrenceMatrix}
\alias{generateOccurrenceMatrix}
\title{Convert epmGrid to community matrix}
\usage{
generateOccurrenceMatrix(x, sites)
}
\arguments{
\item{x}{object of class \code{epmGrid}}

\item{sites}{locations of sites, see details.}
}
\value{
a presence/absence matrix, with sites as 
rows and species as columns.
}
\description{
Given specific sites (or all sites), convert epmGrid to 
	a species occurrence matrix, with sites as rows, and species as columns.
}
\details{
If sites are site coordinates, 
	then this should be a dataframe or matrix with two columns; 
	if sites are cell indices, then a numeric vector;
	if \code{sites = 'all'}, then all cells will be returned as sites. 

To get the associated site coordinates, see \code{\link{coordsFromEpmGrid}}.
}
\examples{
tamiasEPM

# from cell indices
cells <- c(2703, 90, 3112, 179)
generateOccurrenceMatrix(tamiasEPM, cells)

# get the associated site coordinates
coordsFromEpmGrid(tamiasEPM, cells)

# from coordinates
library(sf)
# get the projection of the epmGrid object
proj <- summary(tamiasEPM)$crs
# define some points
pts <- rbind.data.frame(
		c(-120.5, 38.82),
		c(-84.02, 42.75),
		c(-117.95, 55.53))
colnames(pts) <- c('x', 'y')
ptsSF <- st_as_sf(pts, coords = 1:2, crs = "epsg:4326")
pts <- st_coordinates(st_transform(ptsSF, crs = proj))

generateOccurrenceMatrix(tamiasEPM, pts)


}
\author{
Pascal Title
}
