% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/faithPD.R
\name{faithPD}
\alias{faithPD}
\title{Calculate Faith's Phylogenetic Diversity}
\usage{
faithPD(phy, tips)
}
\arguments{
\item{phy}{phylogeny of class \code{phylo}}

\item{tips}{tip names to be included}
}
\value{
numeric value of summed phylogenetic diversity
}
\description{
Calculates Faith's PD for a specific set of tips
}
\details{
Returns the sum of total branch lengths that unite a 
set of species. The root is always included in these calculations. 
If tip is just one species, then the root-to-tip distance is returned.
}
\examples{
tamiasTree
faithPD(tamiasTree, c('Tamias_minimus', 'Tamias_speciosus'))

}
\references{
Faith D.P. (1992) Conservation evaluation and phylogenetic diversity. 
Biological Conservation, 61, 1-10.
}
\author{
Pascal Title
}
