% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impl-idf.R
\name{parse_dots_value}
\alias{parse_dots_value}
\title{Parse object field values given in list format}
\usage{
parse_dots_value(
  ...,
  .scalar = TRUE,
  .pair = FALSE,
  .ref_assign = TRUE,
  .unique = FALSE,
  .empty = FALSE,
  .env = parent.frame()
)
}
\arguments{
\item{...}{Lists of object definitions. Each list should be named
with a valid class/object id/name. ID should be denoted in style
\code{..ID}. There is a special element \code{.comment} in each list, which will
be used as new comments of the object. If \code{.ref_assign} is \code{TRUE},
\verb{:=} can be used to group ids/names:
\itemize{
\item When \code{.type} equals \code{"class"}, LHS multiple class indices/names should be
wrapped by \code{.()}, \code{c()}.
\item When \code{.type} equals \code{"object"}, LHS multiple object ids/names should be
wrapped by \code{.()} or \code{c()}. LHS \strong{SINGLE} class name should be
wrapped by \code{..()}.
}}

\item{.scalar}{If \code{TRUE}, make sure the value of each field in the object is a
scalar value. If \code{FALSE}, \code{value_chr} and \code{value_num} column will be
list type. Default: \code{TRUE}.}

\item{.pair}{Only works when \code{.scalar} is \code{FALSE}. If \code{.pair} is \code{TRUE},
vector field values will be paired to each id/name on the LHS. In this
case, \code{value_chr} and \code{value_num} will be character type and double
type, respectively. When there is only one id/name on the LHS, it will
be replicated to match the length of the value vector. Default: \code{FALSE}.}

\item{.ref_assign}{If \code{TRUE}, allow using \verb{:=} to gather multiple
classes/objects on the LHS when defining the objects. Default: \code{TRUE}.}

\item{.unique}{If \code{TRUE}, make sure there are no duplicated classes/objects in
the input. Default: \code{FALSE}.}

\item{.empty}{If \code{TRUE}, allow using an empty list, i.e. \code{list()} to define an
object with all default values. Default: \code{TRUE}.}

\item{.env}{An environment specifying the environment to evaluate the \code{...}.
Default: \code{\link[=parent.frame]{parent.frame()}}.}
}
\value{
A named list of 2 element \code{object} and \code{value} which is a
\code{\link[data.table:data.table]{data.table::data.table()}} with object data and value data respectively.
}
\description{
Parse object field values given in list format
}
